/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.internal.gestures;

import android.content.res.Resources;
import android.view.View;
import android.view.ViewGroup;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.internal.gestures.GestureTargetLocator;
import io.sentry.internal.gestures.UiElement;
import io.sentry.util.Objects;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ViewUtils {
    ViewUtils() {
    }

    @Nullable
    static UiElement findTarget(@NotNull SentryAndroidOptions options, @NotNull View decorView, float x, float y, UiElement.Type targetType) {
        LinkedList<View> queue = new LinkedList<View>();
        queue.add(decorView);
        UiElement target = null;
        while (queue.size() > 0) {
            View view = (View)Objects.requireNonNull((Object)((View)queue.poll()), (String)"view is required");
            if (view instanceof ViewGroup) {
                ViewGroup viewGroup = (ViewGroup)view;
                for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                    queue.add(viewGroup.getChildAt(i));
                }
            }
            for (GestureTargetLocator locator : options.getGestureTargetLocators()) {
                @Nullable UiElement newTarget = locator.locate((Object)view, x, y, targetType);
                if (newTarget == null) continue;
                if (targetType == UiElement.Type.CLICKABLE) {
                    target = newTarget;
                    continue;
                }
                return newTarget;
            }
        }
        return target;
    }

    static String getResourceIdWithFallback(@NotNull View view) {
        int viewId = view.getId();
        try {
            return ViewUtils.getResourceId(view);
        }
        catch (Resources.NotFoundException e) {
            return "0x" + Integer.toString(viewId, 16);
        }
    }

    static String getResourceId(@NotNull View view) throws Resources.NotFoundException {
        int viewId = view.getId();
        Resources resources = view.getContext().getResources();
        String resourceId = "";
        if (resources != null) {
            resourceId = resources.getResourceEntryName(viewId);
        }
        return resourceId;
    }
}

