/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.os.SystemClock;
import java.util.Date;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class AppStartState {
    @NotNull
    private static AppStartState instance = new AppStartState();
    @Nullable
    private Long appStartMillis;
    @Nullable
    private Long appStartEndMillis;
    @Nullable
    private Boolean coldStart = null;
    @Nullable
    private Date appStartTime;

    private AppStartState() {
    }

    @NotNull
    public static AppStartState getInstance() {
        return instance;
    }

    @TestOnly
    void resetInstance() {
        instance = new AppStartState();
    }

    synchronized void setAppStartEnd() {
        this.setAppStartEnd(SystemClock.uptimeMillis());
    }

    @TestOnly
    void setAppStartEnd(long appStartEndMillis) {
        this.appStartEndMillis = appStartEndMillis;
    }

    @Nullable
    public synchronized Long getAppStartInterval() {
        if (this.appStartMillis == null || this.appStartEndMillis == null || this.coldStart == null) {
            return null;
        }
        return this.appStartEndMillis - this.appStartMillis;
    }

    @Nullable
    public Boolean isColdStart() {
        return this.coldStart;
    }

    synchronized void setColdStart(boolean coldStart) {
        if (this.coldStart != null) {
            return;
        }
        this.coldStart = coldStart;
    }

    @Nullable
    public Date getAppStartTime() {
        return this.appStartTime;
    }

    synchronized void setAppStartTime(long appStartMillis, @NotNull Date appStartTime) {
        if (this.appStartTime != null && this.appStartMillis != null) {
            return;
        }
        this.appStartTime = appStartTime;
        this.appStartMillis = appStartMillis;
    }
}

