/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.os.Process;
import io.sentry.Breadcrumb;
import io.sentry.Hint;
import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.ITransaction;
import io.sentry.Integration;
import io.sentry.Scope;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.SpanStatus;
import io.sentry.android.core.ActivityFramesTracker;
import io.sentry.android.core.AppStartState;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public final class ActivityLifecycleIntegration
implements Integration,
Closeable,
Application.ActivityLifecycleCallbacks {
    static final String UI_LOAD_OP = "ui.load";
    static final String APP_START_WARM = "app.start.warm";
    static final String APP_START_COLD = "app.start.cold";
    @NotNull
    private final Application application;
    @Nullable
    private IHub hub;
    @Nullable
    private SentryAndroidOptions options;
    private boolean performanceEnabled = false;
    private boolean isAllActivityCallbacksAvailable;
    private boolean firstActivityCreated = false;
    private boolean firstActivityResumed = false;
    private boolean foregroundImportance = false;
    @Nullable
    private ISpan appStartSpan;
    @NotNull
    private final WeakHashMap<Activity, ITransaction> activitiesWithOngoingTransactions = new WeakHashMap();
    @NotNull
    private final ActivityFramesTracker activityFramesTracker;

    public ActivityLifecycleIntegration(@NotNull Application application, @NotNull BuildInfoProvider buildInfoProvider, @NotNull ActivityFramesTracker activityFramesTracker) {
        this.application = (Application)Objects.requireNonNull((Object)application, (String)"Application is required");
        Objects.requireNonNull((Object)buildInfoProvider, (String)"BuildInfoProvider is required");
        this.activityFramesTracker = (ActivityFramesTracker)Objects.requireNonNull((Object)activityFramesTracker, (String)"ActivityFramesTracker is required");
        if (buildInfoProvider.getSdkInfoVersion() >= 29) {
            this.isAllActivityCallbacksAvailable = true;
        }
        this.foregroundImportance = this.isForegroundImportance((Context)this.application);
    }

    public void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)(options instanceof SentryAndroidOptions ? (SentryAndroidOptions)options : null)), (String)"SentryAndroidOptions is required"));
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"Hub is required");
        this.options.getLogger().log(SentryLevel.DEBUG, "ActivityLifecycleIntegration enabled: %s", new Object[]{this.options.isEnableActivityLifecycleBreadcrumbs()});
        this.performanceEnabled = this.isPerformanceEnabled(this.options);
        if (this.options.isEnableActivityLifecycleBreadcrumbs() || this.performanceEnabled) {
            this.application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.options.getLogger().log(SentryLevel.DEBUG, "ActivityLifecycleIntegration installed.", new Object[0]);
        }
    }

    private boolean isPerformanceEnabled(@NotNull SentryAndroidOptions options) {
        return options.isTracingEnabled() && options.isEnableAutoActivityLifecycleTracing();
    }

    @Override
    public void close() throws IOException {
        this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        if (this.options != null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "ActivityLifecycleIntegration removed.", new Object[0]);
        }
        this.activityFramesTracker.stop();
    }

    private void addBreadcrumb(@NotNull Activity activity, @NotNull String state) {
        if (this.options != null && this.hub != null && this.options.isEnableActivityLifecycleBreadcrumbs()) {
            Breadcrumb breadcrumb = new Breadcrumb();
            breadcrumb.setType("navigation");
            breadcrumb.setData("state", (Object)state);
            breadcrumb.setData("screen", (Object)this.getActivityName(activity));
            breadcrumb.setCategory("ui.lifecycle");
            breadcrumb.setLevel(SentryLevel.INFO);
            Hint hint = new Hint();
            hint.set("android:activity", (Object)activity);
            this.hub.addBreadcrumb(breadcrumb, hint);
        }
    }

    @NotNull
    private String getActivityName(@NotNull Activity activity) {
        return activity.getClass().getSimpleName();
    }

    private void stopPreviousTransactions() {
        for (Map.Entry<Activity, ITransaction> entry : this.activitiesWithOngoingTransactions.entrySet()) {
            ITransaction transaction = entry.getValue();
            this.finishTransaction(transaction);
        }
    }

    private void startTracing(@NotNull Activity activity) {
        if (this.performanceEnabled && !this.isRunningTransaction(activity) && this.hub != null) {
            ITransaction transaction;
            this.stopPreviousTransactions();
            String activityName = this.getActivityName(activity);
            Date appStartTime = this.foregroundImportance ? AppStartState.getInstance().getAppStartTime() : null;
            Boolean coldStart = AppStartState.getInstance().isColdStart();
            if (this.firstActivityCreated || appStartTime == null || coldStart == null) {
                transaction = this.hub.startTransaction(activityName, UI_LOAD_OP, (Date)null, true, finishingTransaction -> this.activityFramesTracker.setMetrics(activity, finishingTransaction.getEventId()));
            } else {
                transaction = this.hub.startTransaction(activityName, UI_LOAD_OP, appStartTime, true, finishingTransaction -> this.activityFramesTracker.setMetrics(activity, finishingTransaction.getEventId()));
                this.appStartSpan = transaction.startChild(this.getAppStartOp(coldStart), this.getAppStartDesc(coldStart), appStartTime);
            }
            this.hub.configureScope(scope -> this.applyScope(scope, transaction));
            this.activitiesWithOngoingTransactions.put(activity, transaction);
        }
    }

    @VisibleForTesting
    void applyScope(@NotNull Scope scope, @NotNull ITransaction transaction) {
        scope.withTransaction(scopeTransaction -> {
            if (scopeTransaction == null) {
                scope.setTransaction(transaction);
            } else if (this.options != null) {
                this.options.getLogger().log(SentryLevel.DEBUG, "Transaction '%s' won't be bound to the Scope since there's one already in there.", new Object[]{transaction.getName()});
            }
        });
    }

    @VisibleForTesting
    void clearScope(@NotNull Scope scope, @NotNull ITransaction transaction) {
        scope.withTransaction(scopeTransaction -> {
            if (scopeTransaction == transaction) {
                scope.clearTransaction();
            }
        });
    }

    private boolean isRunningTransaction(@NotNull Activity activity) {
        return this.activitiesWithOngoingTransactions.containsKey(activity);
    }

    private void stopTracing(@NotNull Activity activity, boolean shouldFinishTracing) {
        if (this.performanceEnabled && shouldFinishTracing) {
            ITransaction transaction = this.activitiesWithOngoingTransactions.get(activity);
            this.finishTransaction(transaction);
        }
    }

    private void finishTransaction(@Nullable ITransaction transaction) {
        if (transaction != null) {
            if (transaction.isFinished()) {
                return;
            }
            SpanStatus status = transaction.getStatus();
            if (status == null) {
                status = SpanStatus.OK;
            }
            transaction.finish(status);
            if (this.hub != null) {
                this.hub.configureScope(scope -> this.clearScope(scope, transaction));
            }
        }
    }

    public synchronized void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
        this.setColdStart(savedInstanceState);
        this.addBreadcrumb(activity, "created");
        this.startTracing(activity);
        this.firstActivityCreated = true;
    }

    public synchronized void onActivityStarted(@NotNull Activity activity) {
        this.activityFramesTracker.addActivity(activity);
        this.addBreadcrumb(activity, "started");
    }

    public synchronized void onActivityResumed(@NotNull Activity activity) {
        if (!this.firstActivityResumed) {
            if (this.foregroundImportance) {
                AppStartState.getInstance().setAppStartEnd();
            } else if (this.options != null) {
                this.options.getLogger().log(SentryLevel.DEBUG, "App Start won't be reported because Process wasn't of foregroundImportance.", new Object[0]);
            }
            if (this.performanceEnabled && this.appStartSpan != null) {
                this.appStartSpan.finish();
            }
            this.firstActivityResumed = true;
        }
        this.addBreadcrumb(activity, "resumed");
        if (!this.isAllActivityCallbacksAvailable && this.options != null) {
            this.stopTracing(activity, this.options.isEnableActivityLifecycleTracingAutoFinish());
        }
    }

    public synchronized void onActivityPostResumed(@NotNull Activity activity) {
        if (this.isAllActivityCallbacksAvailable && this.options != null) {
            this.stopTracing(activity, this.options.isEnableActivityLifecycleTracingAutoFinish());
        }
    }

    public synchronized void onActivityPaused(@NotNull Activity activity) {
        this.addBreadcrumb(activity, "paused");
    }

    public synchronized void onActivityStopped(@NotNull Activity activity) {
        this.addBreadcrumb(activity, "stopped");
    }

    public synchronized void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
        this.addBreadcrumb(activity, "saveInstanceState");
    }

    public synchronized void onActivityDestroyed(@NotNull Activity activity) {
        this.addBreadcrumb(activity, "destroyed");
        if (this.appStartSpan != null && !this.appStartSpan.isFinished()) {
            this.appStartSpan.finish(SpanStatus.CANCELLED);
        }
        this.stopTracing(activity, true);
        this.appStartSpan = null;
        if (this.performanceEnabled) {
            this.activitiesWithOngoingTransactions.remove(activity);
        }
    }

    @TestOnly
    @NotNull
    WeakHashMap<Activity, ITransaction> getActivitiesWithOngoingTransactions() {
        return this.activitiesWithOngoingTransactions;
    }

    @TestOnly
    @Nullable
    ISpan getAppStartSpan() {
        return this.appStartSpan;
    }

    private void setColdStart(@Nullable Bundle savedInstanceState) {
        if (!this.firstActivityCreated) {
            AppStartState.getInstance().setColdStart(savedInstanceState == null);
        }
    }

    @NotNull
    private String getAppStartDesc(boolean coldStart) {
        if (coldStart) {
            return "Cold Start";
        }
        return "Warm Start";
    }

    @NotNull
    private String getAppStartOp(boolean coldStart) {
        if (coldStart) {
            return APP_START_COLD;
        }
        return APP_START_WARM;
    }

    private boolean isForegroundImportance(@NotNull Context context) {
        try {
            ActivityManager activityManager;
            List runningAppProcesses;
            Object service = context.getSystemService("activity");
            if (service instanceof ActivityManager && (runningAppProcesses = (activityManager = (ActivityManager)service).getRunningAppProcesses()) != null) {
                int myPid = Process.myPid();
                for (ActivityManager.RunningAppProcessInfo processInfo : runningAppProcesses) {
                    if (processInfo.pid != myPid) continue;
                    if (processInfo.importance != 100) break;
                    return true;
                }
            }
        }
        catch (SecurityException securityException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }
}

