/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.internal.util;

import android.os.Looper;
import io.sentry.protocol.SentryThread;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class MainThreadChecker {
    private MainThreadChecker() {
    }

    public static boolean isMainThread(@NotNull Thread thread) {
        return MainThreadChecker.isMainThread(thread.getId());
    }

    public static boolean isMainThread() {
        return MainThreadChecker.isMainThread(Thread.currentThread());
    }

    public static boolean isMainThread(@NotNull SentryThread sentryThread) {
        Long threadId = sentryThread.getId();
        return threadId != null && MainThreadChecker.isMainThread(threadId);
    }

    private static boolean isMainThread(long threadId) {
        return Looper.getMainLooper().getThread().getId() == threadId;
    }
}

