/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.internal.gestures;

import android.content.res.Resources;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ScrollView;
import androidx.core.view.ScrollingView;
import io.sentry.android.core.internal.gestures.ViewTargetSelector;
import io.sentry.util.Objects;
import java.util.ArrayDeque;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ViewUtils {
    ViewUtils() {
    }

    @Nullable
    static View findTarget(@NotNull View decorView, float x, float y, @NotNull ViewTargetSelector viewTargetSelector) {
        ArrayDeque<View> queue = new ArrayDeque<View>();
        queue.add(decorView);
        View target = null;
        int[] coordinates = new int[2];
        while (queue.size() > 0) {
            View view = (View)Objects.requireNonNull((Object)((View)queue.poll()), (String)"view is required");
            if (viewTargetSelector.select(view)) {
                target = view;
                if (viewTargetSelector.skipChildren()) {
                    return target;
                }
            }
            if (!(view instanceof ViewGroup)) continue;
            ViewGroup viewGroup = (ViewGroup)view;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                View child = viewGroup.getChildAt(i);
                if (!ViewUtils.touchWithinBounds(child, x, y, coordinates)) continue;
                queue.add(child);
            }
        }
        return target;
    }

    private static boolean touchWithinBounds(@NotNull View view, float x, float y, int[] coords) {
        view.getLocationOnScreen(coords);
        int vx = coords[0];
        int vy = coords[1];
        int w = view.getWidth();
        int h = view.getHeight();
        return !(x < (float)vx || x > (float)(vx + w) || y < (float)vy || y > (float)(vy + h));
    }

    static boolean isViewTappable(@NotNull View view) {
        return view.isClickable() && view.getVisibility() == 0;
    }

    static boolean isViewScrollable(@NotNull View view, boolean isAndroidXAvailable) {
        return (ViewUtils.isJetpackScrollingView(view, isAndroidXAvailable) || AbsListView.class.isAssignableFrom(view.getClass()) || ScrollView.class.isAssignableFrom(view.getClass())) && view.getVisibility() == 0;
    }

    private static boolean isJetpackScrollingView(@NotNull View view, boolean isAndroidXAvailable) {
        if (!isAndroidXAvailable) {
            return false;
        }
        return ScrollingView.class.isAssignableFrom(view.getClass());
    }

    static String getResourceId(@NotNull View view) {
        int viewId = view.getId();
        Resources resources = view.getContext().getResources();
        String resourceId = "";
        try {
            if (resources != null) {
                resourceId = resources.getResourceEntryName(viewId);
            }
        }
        catch (Resources.NotFoundException e) {
            resourceId = "0x" + Integer.toString(viewId, 16);
        }
        return resourceId;
    }
}

