/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import io.sentry.Breadcrumb;
import io.sentry.IHub;
import io.sentry.Integration;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.internal.util.DeviceOrientations;
import io.sentry.protocol.Device;
import io.sentry.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AppComponentsBreadcrumbsIntegration
implements Integration,
Closeable,
ComponentCallbacks2 {
    @NotNull
    private final Context context;
    @Nullable
    private IHub hub;
    @Nullable
    private SentryAndroidOptions options;

    public AppComponentsBreadcrumbsIntegration(@NotNull Context context) {
        this.context = (Context)Objects.requireNonNull((Object)context, (String)"Context is required");
    }

    public void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"Hub is required");
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)(options instanceof SentryAndroidOptions ? (SentryAndroidOptions)options : null)), (String)"SentryAndroidOptions is required"));
        this.options.getLogger().log(SentryLevel.DEBUG, "AppComponentsBreadcrumbsIntegration enabled: %s", new Object[]{this.options.isEnableAppComponentBreadcrumbs()});
        if (this.options.isEnableAppComponentBreadcrumbs()) {
            try {
                this.context.registerComponentCallbacks((ComponentCallbacks)this);
                options.getLogger().log(SentryLevel.DEBUG, "AppComponentsBreadcrumbsIntegration installed.", new Object[0]);
            }
            catch (Throwable e) {
                this.options.setEnableAppComponentBreadcrumbs(false);
                options.getLogger().log(SentryLevel.INFO, e, "ComponentCallbacks2 is not available.", new Object[0]);
            }
        }
    }

    @Override
    public void close() throws IOException {
        block3: {
            try {
                this.context.unregisterComponentCallbacks((ComponentCallbacks)this);
            }
            catch (Throwable ignored) {
                if (this.options == null) break block3;
                this.options.getLogger().log(SentryLevel.DEBUG, ignored, "It was not possible to unregisterComponentCallbacks", new Object[0]);
            }
        }
        if (this.options != null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "AppComponentsBreadcrumbsIntegration removed.", new Object[0]);
        }
    }

    public void onConfigurationChanged(@NotNull Configuration newConfig) {
        if (this.hub != null) {
            Device.DeviceOrientation deviceOrientation = DeviceOrientations.getOrientation(this.context.getResources().getConfiguration().orientation);
            String orientation = deviceOrientation != null ? deviceOrientation.name().toLowerCase(Locale.ROOT) : "undefined";
            Breadcrumb breadcrumb = new Breadcrumb();
            breadcrumb.setType("navigation");
            breadcrumb.setCategory("device.orientation");
            breadcrumb.setData("position", (Object)orientation);
            breadcrumb.setLevel(SentryLevel.INFO);
            HashMap<String, Configuration> hintMap = new HashMap<String, Configuration>();
            hintMap.put("android:configuration", newConfig);
            this.hub.addBreadcrumb(breadcrumb, hintMap);
        }
    }

    public void onLowMemory() {
        this.createLowMemoryBreadcrumb(null);
    }

    public void onTrimMemory(int level) {
        this.createLowMemoryBreadcrumb(level);
    }

    private void createLowMemoryBreadcrumb(@Nullable Integer level) {
        if (this.hub != null) {
            Breadcrumb breadcrumb = new Breadcrumb();
            if (level != null) {
                if (level < 40) {
                    return;
                }
                breadcrumb.setData("level", (Object)level);
            }
            breadcrumb.setType("system");
            breadcrumb.setCategory("device.event");
            breadcrumb.setMessage("Low memory");
            breadcrumb.setData("action", (Object)"LOW_MEMORY");
            breadcrumb.setLevel(SentryLevel.WARNING);
            this.hub.addBreadcrumb(breadcrumb);
        }
    }
}

