/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.internal.gestures;

import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import io.sentry.Breadcrumb;
import io.sentry.IHub;
import io.sentry.SentryLevel;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.internal.gestures.ViewTargetSelector;
import io.sentry.android.core.internal.gestures.ViewUtils;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SentryGestureListener
implements GestureDetector.OnGestureListener {
    @NotNull
    private final WeakReference<Window> windowRef;
    @NotNull
    private final IHub hub;
    @NotNull
    private final SentryAndroidOptions options;
    private final boolean isAndroidXAvailable;
    private final ScrollState scrollState = new ScrollState();

    public SentryGestureListener(@NotNull WeakReference<Window> windowRef, @NotNull IHub hub, @NotNull SentryAndroidOptions options, boolean isAndroidXAvailable) {
        this.windowRef = windowRef;
        this.hub = hub;
        this.options = options;
        this.isAndroidXAvailable = isAndroidXAvailable;
    }

    public void onUp(@NotNull MotionEvent motionEvent) {
        View decorView = this.ensureWindowDecorView("onUp");
        View scrollTarget = (View)this.scrollState.targetRef.get();
        if (decorView == null || scrollTarget == null) {
            return;
        }
        if (this.scrollState.type == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Unable to define scroll type. No breadcrumb captured.", new Object[0]);
            return;
        }
        String direction = this.scrollState.calculateDirection(motionEvent);
        this.addBreadcrumb(scrollTarget, this.scrollState.type, Collections.singletonMap("direction", direction));
        this.scrollState.reset();
    }

    public boolean onDown(@Nullable MotionEvent motionEvent) {
        if (motionEvent == null) {
            return false;
        }
        this.scrollState.reset();
        this.scrollState.startX = motionEvent.getX();
        this.scrollState.startY = motionEvent.getY();
        return false;
    }

    public boolean onSingleTapUp(@Nullable MotionEvent motionEvent) {
        View decorView = this.ensureWindowDecorView("onSingleTapUp");
        if (decorView == null || motionEvent == null) {
            return false;
        }
        @Nullable View target = ViewUtils.findTarget(decorView, motionEvent.getX(), motionEvent.getY(), view -> ViewUtils.isViewTappable(view));
        if (target == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Unable to find click target. No breadcrumb captured.", new Object[0]);
            return false;
        }
        this.addBreadcrumb(target, "click", Collections.emptyMap());
        return false;
    }

    public boolean onScroll(@Nullable MotionEvent firstEvent, @Nullable MotionEvent currentEvent, float distX, float distY) {
        View decorView = this.ensureWindowDecorView("onScroll");
        if (decorView == null || firstEvent == null) {
            return false;
        }
        if (this.scrollState.type == null) {
            @Nullable View target = ViewUtils.findTarget(decorView, firstEvent.getX(), firstEvent.getY(), new ViewTargetSelector(){

                @Override
                public boolean select(@NotNull View view) {
                    return ViewUtils.isViewScrollable(view, SentryGestureListener.this.isAndroidXAvailable);
                }

                @Override
                public boolean skipChildren() {
                    return true;
                }
            });
            if (target == null) {
                this.options.getLogger().log(SentryLevel.DEBUG, "Unable to find scroll target. No breadcrumb captured.", new Object[0]);
                return false;
            }
            this.scrollState.setTarget(target);
            this.scrollState.type = "scroll";
        }
        return false;
    }

    public boolean onFling(@Nullable MotionEvent motionEvent, @Nullable MotionEvent motionEvent1, float v, float v1) {
        this.scrollState.type = "swipe";
        return false;
    }

    public void onShowPress(MotionEvent motionEvent) {
    }

    public void onLongPress(MotionEvent motionEvent) {
    }

    private void addBreadcrumb(@NotNull View target, @NotNull String eventType, @NotNull Map<String, Object> additionalData) {
        @Nullable String canonicalName = target.getClass().getCanonicalName();
        String className = canonicalName != null ? canonicalName : target.getClass().getSimpleName();
        this.hub.addBreadcrumb(Breadcrumb.userInteraction((String)eventType, (String)ViewUtils.getResourceId(target), (String)className, additionalData));
    }

    @Nullable
    private View ensureWindowDecorView(@NotNull String caller) {
        Window window = (Window)this.windowRef.get();
        if (window == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Window is null in " + caller + ". No breadcrumb captured.", new Object[0]);
            return null;
        }
        View decorView = window.getDecorView();
        if (decorView == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "DecorView is null in " + caller + ". No breadcrumb captured.", new Object[0]);
            return null;
        }
        return decorView;
    }

    private static final class ScrollState {
        @Nullable
        private String type = null;
        private WeakReference<View> targetRef = new WeakReference<Object>(null);
        private float startX = 0.0f;
        private float startY = 0.0f;

        private ScrollState() {
        }

        private void setTarget(@NotNull View target) {
            this.targetRef = new WeakReference<View>(target);
        }

        @NotNull
        private String calculateDirection(MotionEvent endEvent) {
            float diffX = endEvent.getX() - this.startX;
            float diffY = endEvent.getY() - this.startY;
            String direction = Math.abs(diffX) > Math.abs(diffY) ? (diffX > 0.0f ? "right" : "left") : (diffY > 0.0f ? "down" : "up");
            return direction;
        }

        private void reset() {
            this.targetRef.clear();
            this.type = null;
            this.startX = 0.0f;
            this.startY = 0.0f;
        }
    }
}

