/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.app.Application;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.res.AssetManager;
import io.sentry.ILogger;
import io.sentry.Integration;
import io.sentry.SendCachedEnvelopeFireAndForgetIntegration;
import io.sentry.SendFireAndForgetEnvelopeSender;
import io.sentry.SendFireAndForgetOutboxSender;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.core.ActivityFramesTracker;
import io.sentry.android.core.ActivityLifecycleIntegration;
import io.sentry.android.core.AndroidLogger;
import io.sentry.android.core.AndroidTransportGate;
import io.sentry.android.core.AnrIntegration;
import io.sentry.android.core.AppComponentsBreadcrumbsIntegration;
import io.sentry.android.core.AppLifecycleIntegration;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.ContextUtils;
import io.sentry.android.core.DefaultAndroidEventProcessor;
import io.sentry.android.core.EnvelopeFileObserverIntegration;
import io.sentry.android.core.IBuildInfoProvider;
import io.sentry.android.core.Installation;
import io.sentry.android.core.LoadClass;
import io.sentry.android.core.ManifestMetadataReader;
import io.sentry.android.core.NdkIntegration;
import io.sentry.android.core.PerformanceAndroidEventProcessor;
import io.sentry.android.core.PhoneStateBreadcrumbsIntegration;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.SystemEventsBreadcrumbsIntegration;
import io.sentry.android.core.TempSensorBreadcrumbsIntegration;
import io.sentry.android.core.UserInteractionIntegration;
import io.sentry.android.fragment.FragmentLifecycleIntegration;
import io.sentry.android.timber.SentryTimberIntegration;
import io.sentry.util.Objects;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AndroidOptionsInitializer {
    private AndroidOptionsInitializer() {
    }

    static void init(@NotNull SentryAndroidOptions options, @NotNull Context context) {
        Objects.requireNonNull((Object)context, (String)"The application context is required.");
        Objects.requireNonNull((Object)((Object)options), (String)"The options object is required.");
        AndroidOptionsInitializer.init(options, context, new AndroidLogger(), false, false);
    }

    static void init(@NotNull SentryAndroidOptions options, @NotNull Context context, @NotNull ILogger logger, boolean isFragmentAvailable, boolean isTimberAvailable) {
        AndroidOptionsInitializer.init(options, context, logger, new BuildInfoProvider(), isFragmentAvailable, isTimberAvailable);
    }

    static void init(@NotNull SentryAndroidOptions options, @NotNull Context context, @NotNull ILogger logger, @NotNull IBuildInfoProvider buildInfoProvider, boolean isFragmentAvailable, boolean isTimberAvailable) {
        AndroidOptionsInitializer.init(options, context, logger, buildInfoProvider, new LoadClass(), isFragmentAvailable, isTimberAvailable);
    }

    static void init(@NotNull SentryAndroidOptions options, @NotNull Context context, @NotNull ILogger logger, @NotNull IBuildInfoProvider buildInfoProvider, @NotNull LoadClass loadClass, boolean isFragmentAvailable, boolean isTimberAvailable) {
        Objects.requireNonNull((Object)context, (String)"The context is required.");
        if (context.getApplicationContext() != null) {
            context = context.getApplicationContext();
        }
        Objects.requireNonNull((Object)((Object)options), (String)"The options object is required.");
        Objects.requireNonNull((Object)logger, (String)"The ILogger object is required.");
        options.setLogger(logger);
        ManifestMetadataReader.applyMetadata(context, options);
        AndroidOptionsInitializer.initializeCacheDirs(context, options);
        ActivityFramesTracker activityFramesTracker = new ActivityFramesTracker(loadClass, options.getLogger());
        AndroidOptionsInitializer.installDefaultIntegrations(context, options, buildInfoProvider, loadClass, activityFramesTracker, isFragmentAvailable, isTimberAvailable);
        AndroidOptionsInitializer.readDefaultOptionValues(options, context);
        options.addEventProcessor(new DefaultAndroidEventProcessor(context, logger, buildInfoProvider));
        options.addEventProcessor(new PerformanceAndroidEventProcessor(options, activityFramesTracker));
        options.setTransportGate(new AndroidTransportGate(context, options.getLogger()));
    }

    private static void installDefaultIntegrations(@NotNull Context context, @NotNull SentryOptions options, @NotNull IBuildInfoProvider buildInfoProvider, @NotNull LoadClass loadClass, @NotNull ActivityFramesTracker activityFramesTracker, boolean isFragmentAvailable, boolean isTimberAvailable) {
        options.addIntegration((Integration)new SendCachedEnvelopeFireAndForgetIntegration((SendCachedEnvelopeFireAndForgetIntegration.SendFireAndForgetFactory)new SendFireAndForgetEnvelopeSender(() -> options.getCacheDirPath())));
        Class<?> sentryNdkClass = AndroidOptionsInitializer.isNdkAvailable(buildInfoProvider) ? loadClass.loadClass("io.sentry.android.ndk.SentryNdk", options.getLogger()) : null;
        options.addIntegration((Integration)new NdkIntegration(sentryNdkClass));
        options.addIntegration((Integration)EnvelopeFileObserverIntegration.getOutboxFileObserver());
        options.addIntegration((Integration)new SendCachedEnvelopeFireAndForgetIntegration((SendCachedEnvelopeFireAndForgetIntegration.SendFireAndForgetFactory)new SendFireAndForgetOutboxSender(() -> options.getOutboxPath())));
        options.addIntegration((Integration)new AnrIntegration(context));
        options.addIntegration((Integration)new AppLifecycleIntegration());
        if (context instanceof Application) {
            options.addIntegration((Integration)new ActivityLifecycleIntegration((Application)context, buildInfoProvider, activityFramesTracker));
            options.addIntegration((Integration)new UserInteractionIntegration((Application)context, loadClass));
            if (isFragmentAvailable) {
                options.addIntegration((Integration)new FragmentLifecycleIntegration((Application)context, true, true));
            }
        } else {
            options.getLogger().log(SentryLevel.WARNING, "ActivityLifecycle, FragmentLifecycle and UserInteraction Integrations need an Application class to be installed.", new Object[0]);
        }
        if (isTimberAvailable) {
            options.addIntegration((Integration)new SentryTimberIntegration());
        }
        options.addIntegration((Integration)new AppComponentsBreadcrumbsIntegration(context));
        options.addIntegration((Integration)new SystemEventsBreadcrumbsIntegration(context));
        options.addIntegration((Integration)new TempSensorBreadcrumbsIntegration(context));
        options.addIntegration((Integration)new PhoneStateBreadcrumbsIntegration(context));
    }

    private static void readDefaultOptionValues(@NotNull SentryAndroidOptions options, @NotNull Context context) {
        PackageInfo packageInfo = ContextUtils.getPackageInfo(context, options.getLogger());
        if (packageInfo != null) {
            String packageName;
            if (options.getRelease() == null) {
                options.setRelease(AndroidOptionsInitializer.getSentryReleaseVersion(packageInfo, ContextUtils.getVersionCode(packageInfo)));
            }
            if ((packageName = packageInfo.packageName) != null && !packageName.startsWith("android.")) {
                options.addInAppInclude(packageName);
            }
        }
        if (options.getDistinctId() == null) {
            try {
                options.setDistinctId(Installation.id(context));
            }
            catch (RuntimeException e) {
                options.getLogger().log(SentryLevel.ERROR, "Could not generate distinct Id.", (Throwable)e);
            }
        }
        if (options.getProguardUuid() == null) {
            options.setProguardUuid(AndroidOptionsInitializer.getProguardUUID(context, options.getLogger()));
        }
    }

    @Nullable
    private static String getProguardUUID(@NotNull Context context, @NotNull ILogger logger) {
        block9: {
            String string;
            AssetManager assets = context.getAssets();
            BufferedInputStream is = new BufferedInputStream(assets.open("sentry-debug-meta.properties"));
            try {
                Properties properties = new Properties();
                properties.load(is);
                String uuid = properties.getProperty("io.sentry.ProguardUuids");
                logger.log(SentryLevel.DEBUG, "Proguard UUID found: %s", new Object[]{uuid});
                string = uuid;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    logger.log(SentryLevel.INFO, "sentry-debug-meta.properties file was not found.", new Object[0]);
                    break block9;
                }
                catch (IOException e) {
                    logger.log(SentryLevel.ERROR, "Error getting Proguard UUIDs.", (Throwable)e);
                    break block9;
                }
                catch (RuntimeException e) {
                    logger.log(SentryLevel.ERROR, "sentry-debug-meta.properties file is malformed.", (Throwable)e);
                }
            }
            ((InputStream)is).close();
            return string;
        }
        return null;
    }

    @NotNull
    private static String getSentryReleaseVersion(@NotNull PackageInfo packageInfo, @NotNull String versionCode) {
        return packageInfo.packageName + "@" + packageInfo.versionName + "+" + versionCode;
    }

    private static void initializeCacheDirs(@NotNull Context context, @NotNull SentryOptions options) {
        File cacheDir = new File(context.getCacheDir(), "sentry");
        options.setCacheDirPath(cacheDir.getAbsolutePath());
    }

    private static boolean isNdkAvailable(@NotNull IBuildInfoProvider buildInfoProvider) {
        return buildInfoProvider.getSdkInfoVersion() >= 16;
    }
}

