/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.content.Context;
import android.os.SystemClock;
import io.sentry.DateUtils;
import io.sentry.ILogger;
import io.sentry.Integration;
import io.sentry.OptionsContainer;
import io.sentry.Sentry;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.core.AndroidLogger;
import io.sentry.android.core.AndroidOptionsInitializer;
import io.sentry.android.core.AppStartState;
import io.sentry.android.core.LoadClass;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.fragment.FragmentLifecycleIntegration;
import io.sentry.android.timber.SentryTimberIntegration;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import org.jetbrains.annotations.NotNull;

public final class SentryAndroid {
    @NotNull
    private static final Date appStartTime = DateUtils.getCurrentDateTime();
    private static final long appStart = SystemClock.uptimeMillis();
    static final String SENTRY_FRAGMENT_INTEGRATION_CLASS_NAME = "io.sentry.android.fragment.FragmentLifecycleIntegration";
    static final String SENTRY_TIMBER_INTEGRATION_CLASS_NAME = "io.sentry.android.timber.SentryTimberIntegration";

    private SentryAndroid() {
    }

    public static void init(@NotNull Context context) {
        SentryAndroid.init(context, new AndroidLogger());
    }

    public static void init(@NotNull Context context, @NotNull ILogger logger) {
        SentryAndroid.init(context, logger, (Sentry.OptionsConfiguration<SentryAndroidOptions>)((Sentry.OptionsConfiguration)options -> {}));
    }

    public static void init(@NotNull Context context, @NotNull Sentry.OptionsConfiguration<SentryAndroidOptions> configuration) {
        SentryAndroid.init(context, new AndroidLogger(), configuration);
    }

    public static synchronized void init(@NotNull Context context, @NotNull ILogger logger, @NotNull Sentry.OptionsConfiguration<SentryAndroidOptions> configuration) {
        AppStartState.getInstance().setAppStartTime(appStart, appStartTime);
        try {
            Sentry.init((OptionsContainer)OptionsContainer.create(SentryAndroidOptions.class), options -> {
                LoadClass classLoader = new LoadClass();
                boolean isFragmentAvailable = classLoader.isClassAvailable(SENTRY_FRAGMENT_INTEGRATION_CLASS_NAME, options);
                boolean isTimberAvailable = classLoader.isClassAvailable(SENTRY_TIMBER_INTEGRATION_CLASS_NAME, options);
                AndroidOptionsInitializer.init(options, context, logger, isFragmentAvailable, isTimberAvailable);
                configuration.configure(options);
                SentryAndroid.deduplicateIntegrations(options, isFragmentAvailable, isTimberAvailable);
            }, (boolean)true);
        }
        catch (IllegalAccessException e) {
            logger.log(SentryLevel.FATAL, "Fatal error during SentryAndroid.init(...)", (Throwable)e);
            throw new RuntimeException("Failed to initialize Sentry's SDK", e);
        }
        catch (InstantiationException e) {
            logger.log(SentryLevel.FATAL, "Fatal error during SentryAndroid.init(...)", (Throwable)e);
            throw new RuntimeException("Failed to initialize Sentry's SDK", e);
        }
        catch (NoSuchMethodException e) {
            logger.log(SentryLevel.FATAL, "Fatal error during SentryAndroid.init(...)", (Throwable)e);
            throw new RuntimeException("Failed to initialize Sentry's SDK", e);
        }
        catch (InvocationTargetException e) {
            logger.log(SentryLevel.FATAL, "Fatal error during SentryAndroid.init(...)", (Throwable)e);
            throw new RuntimeException("Failed to initialize Sentry's SDK", e);
        }
    }

    private static void deduplicateIntegrations(@NotNull SentryOptions options, boolean isFragmentAvailable, boolean isTimberAvailable) {
        Integration integration2;
        ArrayList<Integration> timberIntegrations = new ArrayList<Integration>();
        ArrayList<Integration> fragmentIntegrations = new ArrayList<Integration>();
        for (Integration integration2 : options.getIntegrations()) {
            if (isFragmentAvailable && integration2 instanceof FragmentLifecycleIntegration) {
                fragmentIntegrations.add(integration2);
            }
            if (!isTimberAvailable || !(integration2 instanceof SentryTimberIntegration)) continue;
            timberIntegrations.add(integration2);
        }
        if (fragmentIntegrations.size() > 1) {
            for (int i = 0; i < fragmentIntegrations.size() - 1; ++i) {
                integration2 = (Integration)fragmentIntegrations.get(i);
                options.getIntegrations().remove(integration2);
            }
        }
        if (timberIntegrations.size() > 1) {
            for (int i = 0; i < timberIntegrations.size() - 1; ++i) {
                integration2 = (Integration)timberIntegrations.get(i);
                options.getIntegrations().remove(integration2);
            }
        }
    }
}

