/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.app.Activity;
import android.util.SparseIntArray;
import androidx.core.app.FrameMetricsAggregator;
import io.sentry.protocol.MeasurementValue;
import io.sentry.protocol.SentryId;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

final class ActivityFramesTracker {
    @NotNull
    private final FrameMetricsAggregator frameMetricsAggregator;
    @NotNull
    private final @NotNull Map<SentryId, Map<String, @NotNull MeasurementValue>> activityMeasurements = new ConcurrentHashMap<SentryId, Map<String, MeasurementValue>>();

    ActivityFramesTracker() {
        this(new FrameMetricsAggregator());
    }

    @TestOnly
    ActivityFramesTracker(@NotNull FrameMetricsAggregator frameMetricsAggregator) {
        this.frameMetricsAggregator = frameMetricsAggregator;
    }

    void addActivity(@NotNull Activity activity) {
        this.frameMetricsAggregator.add(activity);
    }

    void setMetrics(@NotNull Activity activity, @NotNull SentryId sentryId) {
        SparseIntArray totalIndexArray;
        int totalFrames = 0;
        int slowFrames = 0;
        int frozenFrames = 0;
        SparseIntArray[] framesRates = this.frameMetricsAggregator.remove(activity);
        if (framesRates != null && (totalIndexArray = framesRates[0]) != null) {
            for (int i = 0; i < totalIndexArray.size(); ++i) {
                int frameTime = totalIndexArray.keyAt(i);
                int numFrames = totalIndexArray.valueAt(i);
                totalFrames += numFrames;
                if (frameTime > 700) {
                    frozenFrames += numFrames;
                    continue;
                }
                if (frameTime <= 16) continue;
                slowFrames += numFrames;
            }
        }
        if (totalFrames == 0 && slowFrames == 0 && frozenFrames == 0) {
            return;
        }
        MeasurementValue tfValues = new MeasurementValue((float)totalFrames);
        MeasurementValue sfValues = new MeasurementValue((float)slowFrames);
        MeasurementValue ffValues = new MeasurementValue((float)frozenFrames);
        HashMap<String, @NotNull MeasurementValue> measurements = new HashMap<String, MeasurementValue>();
        measurements.put("frames_total", tfValues);
        measurements.put("frames_slow", sfValues);
        measurements.put("frames_frozen", ffValues);
        this.activityMeasurements.put(sentryId, measurements);
    }

    @Nullable Map<String, @NotNull MeasurementValue> takeMetrics(@NotNull SentryId sentryId) {
        Map<String, @NotNull MeasurementValue> stringMeasurementValueMap = this.activityMeasurements.get(sentryId);
        this.activityMeasurements.remove(sentryId);
        return stringMeasurementValueMap;
    }

    void stop() {
        this.frameMetricsAggregator.stop();
        this.activityMeasurements.clear();
    }
}

