/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.sentry.Breadcrumb;
import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.ITransaction;
import io.sentry.Integration;
import io.sentry.Scope;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.SpanStatus;
import io.sentry.android.core.ActivityFramesTracker;
import io.sentry.android.core.AppStartState;
import io.sentry.android.core.IBuildInfoProvider;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public final class ActivityLifecycleIntegration
implements Integration,
Closeable,
Application.ActivityLifecycleCallbacks {
    static final String UI_LOAD_OP = "ui.load";
    static final String APP_START_WARM = "app.start.warm";
    static final String APP_START_COLD = "app.start.cold";
    @NotNull
    private final Application application;
    @Nullable
    private IHub hub;
    @Nullable
    private SentryAndroidOptions options;
    private boolean performanceEnabled = false;
    private boolean isAllActivityCallbacksAvailable;
    private boolean firstActivityCreated = false;
    private boolean firstActivityResumed = false;
    @Nullable
    private ISpan appStartSpan;
    @NotNull
    private final WeakHashMap<Activity, ITransaction> activitiesWithOngoingTransactions = new WeakHashMap();
    @NotNull
    private final ActivityFramesTracker activityFramesTracker;

    public ActivityLifecycleIntegration(@NotNull Application application, @NotNull IBuildInfoProvider buildInfoProvider, @NotNull ActivityFramesTracker activityFramesTracker) {
        this.application = (Application)Objects.requireNonNull((Object)application, (String)"Application is required");
        Objects.requireNonNull((Object)buildInfoProvider, (String)"BuildInfoProvider is required");
        this.activityFramesTracker = (ActivityFramesTracker)Objects.requireNonNull((Object)activityFramesTracker, (String)"ActivityFramesTracker is required");
        if (buildInfoProvider.getSdkInfoVersion() >= 29) {
            this.isAllActivityCallbacksAvailable = true;
        }
    }

    public void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)(options instanceof SentryAndroidOptions ? (SentryAndroidOptions)options : null)), (String)"SentryAndroidOptions is required"));
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"Hub is required");
        this.options.getLogger().log(SentryLevel.DEBUG, "ActivityLifecycleIntegration enabled: %s", new Object[]{this.options.isEnableActivityLifecycleBreadcrumbs()});
        this.performanceEnabled = this.isPerformanceEnabled(this.options);
        if (this.options.isEnableActivityLifecycleBreadcrumbs() || this.performanceEnabled) {
            this.application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.options.getLogger().log(SentryLevel.DEBUG, "ActivityLifecycleIntegration installed.", new Object[0]);
        }
    }

    private boolean isPerformanceEnabled(@NotNull SentryAndroidOptions options) {
        return options.isTracingEnabled() && options.isEnableAutoActivityLifecycleTracing();
    }

    @Override
    public void close() throws IOException {
        this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        if (this.options != null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "ActivityLifecycleIntegration removed.", new Object[0]);
        }
        this.activityFramesTracker.stop();
    }

    private void addBreadcrumb(@NonNull Activity activity, @NotNull String state) {
        if (this.options != null && this.hub != null && this.options.isEnableActivityLifecycleBreadcrumbs()) {
            Breadcrumb breadcrumb = new Breadcrumb();
            breadcrumb.setType("navigation");
            breadcrumb.setData("state", (Object)state);
            breadcrumb.setData("screen", (Object)this.getActivityName(activity));
            breadcrumb.setCategory("ui.lifecycle");
            breadcrumb.setLevel(SentryLevel.INFO);
            this.hub.addBreadcrumb(breadcrumb);
        }
    }

    @NotNull
    private String getActivityName(@NonNull Activity activity) {
        return activity.getClass().getSimpleName();
    }

    private void stopPreviousTransactions() {
        for (Map.Entry<Activity, ITransaction> entry : this.activitiesWithOngoingTransactions.entrySet()) {
            ITransaction transaction = entry.getValue();
            this.finishTransaction(transaction);
        }
    }

    private void startTracing(@NonNull Activity activity) {
        if (this.performanceEnabled && !this.isRunningTransaction(activity) && this.hub != null) {
            ITransaction transaction;
            this.stopPreviousTransactions();
            String activityName = this.getActivityName(activity);
            Date appStartTime = AppStartState.getInstance().getAppStartTime();
            if (this.firstActivityCreated || appStartTime == null) {
                transaction = this.hub.startTransaction(activityName, UI_LOAD_OP, (Date)null, true, finishingTransaction -> this.activityFramesTracker.setMetrics(activity, finishingTransaction.getEventId()));
            } else {
                transaction = this.hub.startTransaction(activityName, UI_LOAD_OP, appStartTime, true, finishingTransaction -> this.activityFramesTracker.setMetrics(activity, finishingTransaction.getEventId()));
                this.appStartSpan = transaction.startChild(this.getAppStartOp(), this.getAppStartDesc(), appStartTime);
            }
            this.hub.configureScope(scope -> this.applyScope(scope, transaction));
            this.activitiesWithOngoingTransactions.put(activity, transaction);
        }
    }

    @VisibleForTesting
    void applyScope(@NotNull Scope scope, @NotNull ITransaction transaction) {
        scope.withTransaction(scopeTransaction -> {
            if (scopeTransaction == null) {
                scope.setTransaction(transaction);
            } else if (this.options != null) {
                this.options.getLogger().log(SentryLevel.DEBUG, "Transaction '%s' won't be bound to the Scope since there's one already in there.", new Object[]{transaction.getName()});
            }
        });
    }

    private boolean isRunningTransaction(@NonNull Activity activity) {
        return this.activitiesWithOngoingTransactions.containsKey(activity);
    }

    private void stopTracing(@NonNull Activity activity, boolean shouldFinishTracing) {
        if (this.performanceEnabled && shouldFinishTracing) {
            ITransaction transaction = this.activitiesWithOngoingTransactions.get(activity);
            this.finishTransaction(transaction);
        }
    }

    private void finishTransaction(@Nullable ITransaction transaction) {
        if (transaction != null) {
            if (transaction.isFinished()) {
                return;
            }
            SpanStatus status = transaction.getStatus();
            if (status == null) {
                status = SpanStatus.OK;
            }
            transaction.finish(status);
        }
    }

    public synchronized void onActivityPreCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
        if (this.isAllActivityCallbacksAvailable) {
            this.activityFramesTracker.addActivity(activity);
            this.setColdStart(savedInstanceState);
            this.startTracing(activity);
        }
    }

    public synchronized void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
        if (!this.isAllActivityCallbacksAvailable) {
            this.activityFramesTracker.addActivity(activity);
            this.setColdStart(savedInstanceState);
        }
        this.addBreadcrumb(activity, "created");
        if (!this.isAllActivityCallbacksAvailable) {
            this.startTracing(activity);
        }
        this.firstActivityCreated = true;
    }

    public synchronized void onActivityStarted(@NonNull Activity activity) {
        this.addBreadcrumb(activity, "started");
    }

    public synchronized void onActivityResumed(@NonNull Activity activity) {
        if (!this.firstActivityResumed && this.performanceEnabled) {
            AppStartState.getInstance().setAppStartEnd();
            if (this.appStartSpan != null) {
                this.appStartSpan.finish();
            }
            this.firstActivityResumed = true;
        }
        this.addBreadcrumb(activity, "resumed");
        if (!this.isAllActivityCallbacksAvailable && this.options != null) {
            this.stopTracing(activity, this.options.isEnableActivityLifecycleTracingAutoFinish());
        }
    }

    public synchronized void onActivityPostResumed(@NonNull Activity activity) {
        if (this.isAllActivityCallbacksAvailable && this.options != null) {
            this.stopTracing(activity, this.options.isEnableActivityLifecycleTracingAutoFinish());
        }
    }

    public synchronized void onActivityPaused(@NonNull Activity activity) {
        this.addBreadcrumb(activity, "paused");
    }

    public synchronized void onActivityStopped(@NonNull Activity activity) {
        this.addBreadcrumb(activity, "stopped");
    }

    public synchronized void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
        this.addBreadcrumb(activity, "saveInstanceState");
    }

    public synchronized void onActivityDestroyed(@NonNull Activity activity) {
        this.addBreadcrumb(activity, "destroyed");
        this.stopTracing(activity, true);
        if (this.performanceEnabled) {
            this.activitiesWithOngoingTransactions.remove(activity);
        }
    }

    @TestOnly
    @NotNull
    WeakHashMap<Activity, ITransaction> getActivitiesWithOngoingTransactions() {
        return this.activitiesWithOngoingTransactions;
    }

    private void setColdStart(@Nullable Bundle savedInstanceState) {
        if (!this.firstActivityCreated && this.performanceEnabled) {
            AppStartState.getInstance().setColdStart(savedInstanceState == null);
        }
    }

    @NotNull
    private String getAppStartDesc() {
        if (AppStartState.getInstance().isColdStart()) {
            return "Cold Start";
        }
        return "Warm Start";
    }

    @NotNull
    private String getAppStartOp() {
        if (AppStartState.getInstance().isColdStart()) {
            return APP_START_COLD;
        }
        return APP_START_WARM;
    }
}

