/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.app.Application;
import android.content.Context;
import android.content.pm.PackageInfo;
import io.sentry.ILogger;
import io.sentry.Integration;
import io.sentry.SendCachedEnvelopeFireAndForgetIntegration;
import io.sentry.SendFireAndForgetEnvelopeSender;
import io.sentry.SendFireAndForgetOutboxSender;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.core.ActivityLifecycleIntegration;
import io.sentry.android.core.AndroidLogger;
import io.sentry.android.core.AndroidTransportGate;
import io.sentry.android.core.AnrIntegration;
import io.sentry.android.core.AppComponentsBreadcrumbsIntegration;
import io.sentry.android.core.AppLifecycleIntegration;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.ContextUtils;
import io.sentry.android.core.DefaultAndroidEventProcessor;
import io.sentry.android.core.EnvelopeFileObserverIntegration;
import io.sentry.android.core.IBuildInfoProvider;
import io.sentry.android.core.ILoadClass;
import io.sentry.android.core.Installation;
import io.sentry.android.core.LoadClass;
import io.sentry.android.core.ManifestMetadataReader;
import io.sentry.android.core.NdkIntegration;
import io.sentry.android.core.PerformanceAndroidEventProcessor;
import io.sentry.android.core.PhoneStateBreadcrumbsIntegration;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.SystemEventsBreadcrumbsIntegration;
import io.sentry.android.core.TempSensorBreadcrumbsIntegration;
import io.sentry.util.Objects;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AndroidOptionsInitializer {
    private AndroidOptionsInitializer() {
    }

    static void init(@NotNull SentryAndroidOptions options, @NotNull Context context) {
        Objects.requireNonNull((Object)context, (String)"The application context is required.");
        Objects.requireNonNull((Object)((Object)options), (String)"The options object is required.");
        AndroidOptionsInitializer.init(options, context, new AndroidLogger());
    }

    static void init(@NotNull SentryAndroidOptions options, @NotNull Context context, @NotNull ILogger logger) {
        AndroidOptionsInitializer.init(options, context, logger, new BuildInfoProvider());
    }

    static void init(@NotNull SentryAndroidOptions options, @NotNull Context context, @NotNull ILogger logger, @NotNull IBuildInfoProvider buildInfoProvider) {
        AndroidOptionsInitializer.init(options, context, logger, buildInfoProvider, new LoadClass());
    }

    static void init(@NotNull SentryAndroidOptions options, @NotNull Context context, @NotNull ILogger logger, @NotNull IBuildInfoProvider buildInfoProvider, @NotNull ILoadClass loadClass) {
        Objects.requireNonNull((Object)context, (String)"The context is required.");
        if (context.getApplicationContext() != null) {
            context = context.getApplicationContext();
        }
        Objects.requireNonNull((Object)((Object)options), (String)"The options object is required.");
        Objects.requireNonNull((Object)logger, (String)"The ILogger object is required.");
        options.setLogger(logger);
        ManifestMetadataReader.applyMetadata(context, options);
        AndroidOptionsInitializer.initializeCacheDirs(context, options);
        AndroidOptionsInitializer.installDefaultIntegrations(context, options, buildInfoProvider, loadClass);
        AndroidOptionsInitializer.readDefaultOptionValues(options, context);
        options.addEventProcessor(new DefaultAndroidEventProcessor(context, logger, buildInfoProvider));
        options.addEventProcessor(new PerformanceAndroidEventProcessor(options));
        options.setTransportGate(new AndroidTransportGate(context, options.getLogger()));
    }

    private static void installDefaultIntegrations(@NotNull Context context, @NotNull SentryOptions options, @NotNull IBuildInfoProvider buildInfoProvider, @NotNull ILoadClass loadClass) {
        options.addIntegration((Integration)new SendCachedEnvelopeFireAndForgetIntegration((SendCachedEnvelopeFireAndForgetIntegration.SendFireAndForgetFactory)new SendFireAndForgetEnvelopeSender(() -> options.getCacheDirPath())));
        Class<?> sentryNdkClass = AndroidOptionsInitializer.loadNdkIfAvailable(options, buildInfoProvider, loadClass);
        options.addIntegration((Integration)new NdkIntegration(sentryNdkClass));
        options.addIntegration((Integration)EnvelopeFileObserverIntegration.getOutboxFileObserver());
        options.addIntegration((Integration)new SendCachedEnvelopeFireAndForgetIntegration((SendCachedEnvelopeFireAndForgetIntegration.SendFireAndForgetFactory)new SendFireAndForgetOutboxSender(() -> options.getOutboxPath())));
        options.addIntegration((Integration)new AnrIntegration(context));
        options.addIntegration((Integration)new AppLifecycleIntegration());
        if (context instanceof Application) {
            options.addIntegration((Integration)new ActivityLifecycleIntegration((Application)context, buildInfoProvider));
        } else {
            options.getLogger().log(SentryLevel.WARNING, "ActivityBreadcrumbsIntegration needs an Application class to be installed.", new Object[0]);
        }
        options.addIntegration((Integration)new AppComponentsBreadcrumbsIntegration(context));
        options.addIntegration((Integration)new SystemEventsBreadcrumbsIntegration(context));
        options.addIntegration((Integration)new TempSensorBreadcrumbsIntegration(context));
        options.addIntegration((Integration)new PhoneStateBreadcrumbsIntegration(context));
    }

    private static void readDefaultOptionValues(@NotNull SentryAndroidOptions options, @NotNull Context context) {
        PackageInfo packageInfo = ContextUtils.getPackageInfo(context, options.getLogger());
        if (packageInfo != null) {
            String packageName;
            if (options.getRelease() == null) {
                options.setRelease(AndroidOptionsInitializer.getSentryReleaseVersion(packageInfo, ContextUtils.getVersionCode(packageInfo)));
            }
            if ((packageName = packageInfo.packageName) != null && !packageName.startsWith("android.")) {
                options.addInAppInclude(packageName);
            }
        }
        if (options.getDistinctId() == null) {
            try {
                options.setDistinctId(Installation.id(context));
            }
            catch (RuntimeException e) {
                options.getLogger().log(SentryLevel.ERROR, "Could not generate distinct Id.", (Throwable)e);
            }
        }
    }

    @NotNull
    private static String getSentryReleaseVersion(@NotNull PackageInfo packageInfo, @NotNull String versionCode) {
        return packageInfo.packageName + "@" + packageInfo.versionName + "+" + versionCode;
    }

    private static void initializeCacheDirs(@NotNull Context context, @NotNull SentryOptions options) {
        File cacheDir = new File(context.getCacheDir(), "sentry");
        options.setCacheDirPath(cacheDir.getAbsolutePath());
    }

    private static boolean isNdkAvailable(@NotNull IBuildInfoProvider buildInfoProvider) {
        return buildInfoProvider.getSdkInfoVersion() >= 16;
    }

    @Nullable
    private static Class<?> loadNdkIfAvailable(@NotNull SentryOptions options, @NotNull IBuildInfoProvider buildInfoProvider, @NotNull ILoadClass loadClass) {
        if (AndroidOptionsInitializer.isNdkAvailable(buildInfoProvider)) {
            try {
                return loadClass.loadClass("io.sentry.android.ndk.SentryNdk");
            }
            catch (ClassNotFoundException e) {
                options.getLogger().log(SentryLevel.ERROR, "Failed to load SentryNdk.", (Throwable)e);
            }
            catch (UnsatisfiedLinkError e) {
                options.getLogger().log(SentryLevel.ERROR, "Failed to load (UnsatisfiedLinkError) SentryNdk.", (Throwable)e);
            }
            catch (Throwable e) {
                options.getLogger().log(SentryLevel.ERROR, "Failed to initialize SentryNdk.", e);
            }
        }
        return null;
    }
}

