/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import io.sentry.EventProcessor;
import io.sentry.android.core.AppStartState;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.protocol.MeasurementValue;
import io.sentry.protocol.SentrySpan;
import io.sentry.protocol.SentryTransaction;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PerformanceAndroidEventProcessor
implements EventProcessor {
    private final boolean tracingEnabled;
    private boolean sentStartMeasurement = false;

    PerformanceAndroidEventProcessor(@NotNull SentryAndroidOptions options) {
        this.tracingEnabled = options.isTracingEnabled();
    }

    @NotNull
    public synchronized SentryTransaction process(@NotNull SentryTransaction transaction, @Nullable Object hint) {
        Long appStartUpInterval;
        if (!this.sentStartMeasurement && this.tracingEnabled && this.hasAppStartSpan(transaction.getSpans()) && (appStartUpInterval = AppStartState.getInstance().getAppStartInterval()) != null) {
            MeasurementValue value = new MeasurementValue((float)appStartUpInterval.longValue());
            String appStartKey = AppStartState.getInstance().isColdStart() ? "app_start_cold" : "app_start_warm";
            transaction.getMeasurements().put(appStartKey, value);
            this.sentStartMeasurement = true;
        }
        return transaction;
    }

    private boolean hasAppStartSpan(@NotNull List<SentrySpan> spans) {
        for (SentrySpan span : spans) {
            if (!span.getOp().contentEquals("app.start.cold") && !span.getOp().contentEquals("app.start.warm")) continue;
            return true;
        }
        return false;
    }
}

