/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.sentry.Breadcrumb;
import io.sentry.IHub;
import io.sentry.ITransaction;
import io.sentry.Integration;
import io.sentry.Scope;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.SpanStatus;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public final class ActivityLifecycleIntegration
implements Integration,
Closeable,
Application.ActivityLifecycleCallbacks {
    @NotNull
    private final Application application;
    @NotNull
    private IHub hub;
    @NotNull
    private SentryAndroidOptions options;
    private boolean performanceEnabled = false;
    @NotNull
    private final WeakHashMap<Activity, ITransaction> activitiesWithOngoingTransactions = new WeakHashMap();

    public ActivityLifecycleIntegration(@NotNull Application application) {
        this.application = (Application)Objects.requireNonNull((Object)application, (String)"Application is required");
    }

    public void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)(options instanceof SentryAndroidOptions ? (SentryAndroidOptions)options : null)), (String)"SentryAndroidOptions is required"));
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"Hub is required");
        this.options.getLogger().log(SentryLevel.DEBUG, "ActivityLifecycleIntegration enabled: %s", new Object[]{this.options.isEnableActivityLifecycleBreadcrumbs()});
        this.performanceEnabled = this.isPerformanceEnabled(this.options);
        if (this.options.isEnableActivityLifecycleBreadcrumbs() || this.performanceEnabled) {
            this.application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.options.getLogger().log(SentryLevel.DEBUG, "ActivityLifecycleIntegration installed.", new Object[0]);
        }
    }

    private boolean isPerformanceEnabled(@NotNull SentryAndroidOptions options) {
        return (options.getTracesSampleRate() != null || options.getTracesSampler() != null) && options.isEnableAutoActivityLifecycleTracing();
    }

    @Override
    public void close() throws IOException {
        this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        this.options.getLogger().log(SentryLevel.DEBUG, "ActivityLifecycleIntegration removed.", new Object[0]);
    }

    private void addBreadcrumb(@NonNull Activity activity, @NotNull String state) {
        if (this.options.isEnableActivityLifecycleBreadcrumbs()) {
            Breadcrumb breadcrumb = new Breadcrumb();
            breadcrumb.setType("navigation");
            breadcrumb.setData("state", (Object)state);
            breadcrumb.setData("screen", (Object)this.getActivityName(activity));
            breadcrumb.setCategory("ui.lifecycle");
            breadcrumb.setLevel(SentryLevel.INFO);
            this.hub.addBreadcrumb(breadcrumb);
        }
    }

    @NotNull
    private String getActivityName(@NonNull Activity activity) {
        return activity.getClass().getSimpleName();
    }

    private void stopPreviousTransactions() {
        for (Map.Entry<Activity, ITransaction> entry : this.activitiesWithOngoingTransactions.entrySet()) {
            ITransaction transaction = entry.getValue();
            this.finishTransaction(transaction);
        }
    }

    private void startTracing(@NonNull Activity activity) {
        if (this.performanceEnabled && !this.isRunningTransaction(activity)) {
            this.stopPreviousTransactions();
            ITransaction transaction = this.hub.startTransaction(this.getActivityName(activity), "navigation");
            this.hub.configureScope(scope -> this.applyScope(scope, transaction));
            this.activitiesWithOngoingTransactions.put(activity, transaction);
        }
    }

    @VisibleForTesting
    void applyScope(@NotNull Scope scope, @NotNull ITransaction transaction) {
        scope.withTransaction(scopeTransaction -> {
            if (scopeTransaction == null) {
                scope.setTransaction(transaction);
            } else {
                this.options.getLogger().log(SentryLevel.DEBUG, "Transaction '%s' won't be bound to the Scope since there's one already in there.", new Object[]{transaction.getName()});
            }
        });
    }

    private boolean isRunningTransaction(@NonNull Activity activity) {
        return this.activitiesWithOngoingTransactions.containsKey(activity);
    }

    private void stopTracing(@NonNull Activity activity, boolean shouldFinishTracing) {
        if (this.performanceEnabled && shouldFinishTracing) {
            ITransaction transaction = this.activitiesWithOngoingTransactions.get(activity);
            this.finishTransaction(transaction);
        }
    }

    private void finishTransaction(@Nullable ITransaction transaction) {
        if (transaction != null) {
            SpanStatus status = transaction.getStatus();
            if (status == null) {
                status = SpanStatus.OK;
            }
            transaction.finish(status);
        }
    }

    public synchronized void onActivityPreCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
        this.startTracing(activity);
    }

    public synchronized void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
        this.addBreadcrumb(activity, "created");
    }

    public synchronized void onActivityStarted(@NonNull Activity activity) {
        this.addBreadcrumb(activity, "started");
    }

    public synchronized void onActivityResumed(@NonNull Activity activity) {
        this.addBreadcrumb(activity, "resumed");
    }

    public synchronized void onActivityPostResumed(@NonNull Activity activity) {
        this.stopTracing(activity, this.options.isEnableActivityLifecycleTracingAutoFinish());
    }

    public synchronized void onActivityPaused(@NonNull Activity activity) {
        this.addBreadcrumb(activity, "paused");
    }

    public synchronized void onActivityStopped(@NonNull Activity activity) {
        this.addBreadcrumb(activity, "stopped");
    }

    public synchronized void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
        this.addBreadcrumb(activity, "saveInstanceState");
    }

    public synchronized void onActivityDestroyed(@NonNull Activity activity) {
        this.addBreadcrumb(activity, "destroyed");
        this.stopTracing(activity, true);
        if (this.performanceEnabled) {
            this.activitiesWithOngoingTransactions.remove(activity);
        }
    }

    @TestOnly
    @NotNull
    WeakHashMap<Activity, ITransaction> getActivitiesWithOngoingTransactions() {
        return this.activitiesWithOngoingTransactions;
    }
}

