/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.os.FileObserver;
import io.sentry.IEnvelopeSender;
import io.sentry.ILogger;
import io.sentry.SentryLevel;
import io.sentry.hints.ApplyScopeData;
import io.sentry.hints.Cached;
import io.sentry.hints.Flushable;
import io.sentry.hints.Resettable;
import io.sentry.hints.Retryable;
import io.sentry.hints.SubmissionResult;
import io.sentry.util.Objects;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class EnvelopeFileObserver
extends FileObserver {
    private final String rootPath;
    private final IEnvelopeSender envelopeSender;
    @NotNull
    private final ILogger logger;
    private final long flushTimeoutMillis;

    EnvelopeFileObserver(String path, IEnvelopeSender envelopeSender, @NotNull ILogger logger, long flushTimeoutMillis) {
        super(path);
        this.rootPath = (String)Objects.requireNonNull((Object)path, (String)"File path is required.");
        this.envelopeSender = (IEnvelopeSender)Objects.requireNonNull((Object)envelopeSender, (String)"Envelope sender is required.");
        this.logger = (ILogger)Objects.requireNonNull((Object)logger, (String)"Logger is required.");
        this.flushTimeoutMillis = flushTimeoutMillis;
    }

    public void onEvent(int eventType, @Nullable String relativePath) {
        if (relativePath == null || eventType != 8) {
            return;
        }
        this.logger.log(SentryLevel.DEBUG, "onEvent fired for EnvelopeFileObserver with event type %d on path: %s for file %s.", new Object[]{eventType, this.rootPath, relativePath});
        CachedEnvelopeHint hint = new CachedEnvelopeHint(this.flushTimeoutMillis, this.logger);
        this.envelopeSender.processEnvelopeFile(this.rootPath + File.separator + relativePath, (Object)hint);
    }

    private static final class CachedEnvelopeHint
    implements Cached,
    Retryable,
    SubmissionResult,
    Flushable,
    ApplyScopeData,
    Resettable {
        boolean retry;
        boolean succeeded;
        @NotNull
        private CountDownLatch latch;
        private final long flushTimeoutMillis;
        @NotNull
        private final ILogger logger;

        public CachedEnvelopeHint(long flushTimeoutMillis, @NotNull ILogger logger) {
            this.reset();
            this.flushTimeoutMillis = flushTimeoutMillis;
            this.logger = (ILogger)Objects.requireNonNull((Object)logger, (String)"ILogger is required.");
        }

        public boolean waitFlush() {
            try {
                return this.latch.await(this.flushTimeoutMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.log(SentryLevel.ERROR, "Exception while awaiting on lock.", (Throwable)e);
                return false;
            }
        }

        public boolean isRetry() {
            return this.retry;
        }

        public void setRetry(boolean retry) {
            this.retry = retry;
        }

        public void setResult(boolean succeeded) {
            this.succeeded = succeeded;
            this.latch.countDown();
        }

        public boolean isSuccess() {
            return this.succeeded;
        }

        public void reset() {
            this.latch = new CountDownLatch(1);
            this.retry = false;
            this.succeeded = false;
        }
    }
}

