/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import io.sentry.IHub;
import io.sentry.Integration;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.util.Objects;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class NdkIntegration
implements Integration {
    public static final String SENTRY_NDK_CLASS_NAME = "io.sentry.android.ndk.SentryNdk";
    @Nullable
    private final Class<?> sentryNdkClass;

    public NdkIntegration(@Nullable Class<?> sentryNdkClass) {
        this.sentryNdkClass = sentryNdkClass;
    }

    public final void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        Objects.requireNonNull((Object)hub, (String)"Hub is required");
        SentryAndroidOptions androidOptions = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)(options instanceof SentryAndroidOptions ? (SentryAndroidOptions)options : null)), (String)"SentryAndroidOptions is required"));
        boolean enabled = androidOptions.isEnableNdk();
        androidOptions.getLogger().log(SentryLevel.DEBUG, "NdkIntegration enabled: %s", new Object[]{enabled});
        if (enabled && this.sentryNdkClass != null) {
            String cachedDir = androidOptions.getCacheDirPath();
            if (cachedDir == null || cachedDir.isEmpty()) {
                androidOptions.getLogger().log(SentryLevel.ERROR, "No cache dir path is defined in options.", new Object[0]);
                androidOptions.setEnableNdk(false);
                return;
            }
            try {
                Method method = this.sentryNdkClass.getMethod("init", SentryAndroidOptions.class);
                Object[] args = new Object[]{androidOptions};
                method.invoke(null, args);
                androidOptions.getLogger().log(SentryLevel.DEBUG, "NdkIntegration installed.", new Object[0]);
            }
            catch (NoSuchMethodException e) {
                androidOptions.setEnableNdk(false);
                androidOptions.getLogger().log(SentryLevel.ERROR, "Failed to invoke the SentryNdk.init method.", (Throwable)e);
            }
            catch (Throwable e) {
                androidOptions.setEnableNdk(false);
                androidOptions.getLogger().log(SentryLevel.ERROR, "Failed to initialize SentryNdk.", e);
            }
        } else {
            androidOptions.setEnableNdk(false);
        }
    }

    @TestOnly
    @Nullable
    Class<?> getSentryNdkClass() {
        return this.sentryNdkClass;
    }
}

