/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import io.sentry.ILogger;
import io.sentry.SentryLevel;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.util.Objects;
import java.util.Locale;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ManifestMetadataReader {
    static final String DSN = "io.sentry.dsn";
    static final String DEBUG = "io.sentry.debug";
    static final String DEBUG_LEVEL = "io.sentry.debug.level";
    static final String SAMPLE_RATE = "io.sentry.sample-rate";
    static final String ANR_ENABLE = "io.sentry.anr.enable";
    static final String ANR_REPORT_DEBUG = "io.sentry.anr.report-debug";
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    static final String ANR_TIMEOUT_INTERVAL_MILLS = "io.sentry.anr.timeout-interval-mills";
    static final String ANR_TIMEOUT_INTERVAL_MILLIS = "io.sentry.anr.timeout-interval-millis";
    static final String AUTO_INIT = "io.sentry.auto-init";
    static final String NDK_ENABLE = "io.sentry.ndk.enable";
    static final String NDK_SCOPE_SYNC_ENABLE = "io.sentry.ndk.scope-sync.enable";
    static final String RELEASE = "io.sentry.release";
    static final String ENVIRONMENT = "io.sentry.environment";
    static final String SESSION_TRACKING_ENABLE = "io.sentry.session-tracking.enable";
    static final String SESSION_TRACKING_TIMEOUT_INTERVAL_MILLIS = "io.sentry.session-tracking.timeout-interval-millis";
    static final String BREADCRUMBS_ACTIVITY_LIFECYCLE_ENABLE = "io.sentry.breadcrumbs.activity-lifecycle";
    static final String BREADCRUMBS_APP_LIFECYCLE_ENABLE = "io.sentry.breadcrumbs.app-lifecycle";
    static final String BREADCRUMBS_SYSTEM_EVENTS_ENABLE = "io.sentry.breadcrumbs.system-events";
    static final String BREADCRUMBS_APP_COMPONENTS_ENABLE = "io.sentry.breadcrumbs.app-components";
    static final String UNCAUGHT_EXCEPTION_HANDLER_ENABLE = "io.sentry.uncaught-exception-handler.enable";
    static final String ATTACH_THREADS = "io.sentry.attach-threads";

    private ManifestMetadataReader() {
    }

    static void applyMetadata(@NotNull Context context, @NotNull SentryAndroidOptions options) {
        Objects.requireNonNull((Object)context, (String)"The application context is required.");
        Objects.requireNonNull((Object)((Object)options), (String)"The options object is required.");
        try {
            Bundle metadata = ManifestMetadataReader.getMetadata(context);
            if (metadata != null) {
                boolean debug = metadata.getBoolean(DEBUG, options.isDebug());
                options.setDebug(debug);
                options.getLogger().log(SentryLevel.DEBUG, "debug read: %s", new Object[]{debug});
                if (options.isDebug()) {
                    String level = metadata.getString(DEBUG_LEVEL, options.getDiagnosticLevel().name().toLowerCase(Locale.ROOT));
                    options.setDiagnosticLevel(SentryLevel.valueOf((String)level.toUpperCase(Locale.ROOT)));
                }
                boolean anrEnabled = metadata.getBoolean(ANR_ENABLE, options.isAnrEnabled());
                options.getLogger().log(SentryLevel.DEBUG, "anrEnabled read: %s", new Object[]{anrEnabled});
                options.setAnrEnabled(anrEnabled);
                boolean sessionTrackingEnabled = metadata.getBoolean(SESSION_TRACKING_ENABLE, options.isEnableSessionTracking());
                options.getLogger().log(SentryLevel.DEBUG, "sessionTrackingEnabled read: %s", new Object[]{sessionTrackingEnabled});
                options.setEnableSessionTracking(sessionTrackingEnabled);
                if (options.getSampleRate() == null) {
                    Double sampleRate = Float.valueOf(metadata.getFloat(SAMPLE_RATE, -1.0f)).doubleValue();
                    options.getLogger().log(SentryLevel.DEBUG, "sampleRate read: %s", new Object[]{sampleRate});
                    if (sampleRate != -1.0) {
                        options.setSampleRate(sampleRate);
                    }
                }
                boolean anrReportInDebug = metadata.getBoolean(ANR_REPORT_DEBUG, options.isAnrReportInDebug());
                options.getLogger().log(SentryLevel.DEBUG, "anrReportInDebug read: %s", new Object[]{anrReportInDebug});
                options.setAnrReportInDebug(anrReportInDebug);
                long anrTimeoutIntervalMills = metadata.getInt(ANR_TIMEOUT_INTERVAL_MILLS, (int)options.getAnrTimeoutIntervalMillis());
                long anrTimeoutIntervalMillis = metadata.getInt(ANR_TIMEOUT_INTERVAL_MILLIS, (int)anrTimeoutIntervalMills);
                options.getLogger().log(SentryLevel.DEBUG, "anrTimeoutIntervalMillis read: %d", new Object[]{anrTimeoutIntervalMillis});
                options.setAnrTimeoutIntervalMillis(anrTimeoutIntervalMillis);
                String dsn = metadata.getString(DSN, null);
                if (dsn == null) {
                    options.getLogger().log(SentryLevel.FATAL, "DSN is required. Use empty string to disable SDK.", new Object[0]);
                } else if (dsn.isEmpty()) {
                    options.getLogger().log(SentryLevel.DEBUG, "DSN is empty, disabling sentry-android", new Object[0]);
                } else {
                    options.getLogger().log(SentryLevel.DEBUG, "DSN read: %s", new Object[]{dsn});
                }
                options.setDsn(dsn);
                boolean ndk = metadata.getBoolean(NDK_ENABLE, options.isEnableNdk());
                options.getLogger().log(SentryLevel.DEBUG, "NDK read: %s", new Object[]{ndk});
                options.setEnableNdk(ndk);
                boolean ndkScopeSync = metadata.getBoolean(NDK_SCOPE_SYNC_ENABLE, options.isEnableScopeSync());
                options.getLogger().log(SentryLevel.DEBUG, "ndkScopeSync read: %s", new Object[]{ndkScopeSync});
                options.setEnableScopeSync(ndkScopeSync);
                String release = metadata.getString(RELEASE, options.getRelease());
                options.getLogger().log(SentryLevel.DEBUG, "release read: %s", new Object[]{release});
                options.setRelease(release);
                String environment = metadata.getString(ENVIRONMENT, options.getEnvironment());
                options.getLogger().log(SentryLevel.DEBUG, "environment read: %s", new Object[]{environment});
                options.setEnvironment(environment);
                long sessionTrackingTimeoutIntervalMillis = metadata.getInt(SESSION_TRACKING_TIMEOUT_INTERVAL_MILLIS, (int)options.getSessionTrackingIntervalMillis());
                options.getLogger().log(SentryLevel.DEBUG, "sessionTrackingTimeoutIntervalMillis read: %d", new Object[]{sessionTrackingTimeoutIntervalMillis});
                options.setSessionTrackingIntervalMillis(sessionTrackingTimeoutIntervalMillis);
                boolean enableActivityLifecycleBreadcrumbs = metadata.getBoolean(BREADCRUMBS_ACTIVITY_LIFECYCLE_ENABLE, options.isEnableActivityLifecycleBreadcrumbs());
                options.getLogger().log(SentryLevel.DEBUG, "enableActivityLifecycleBreadcrumbs read: %s", new Object[]{ndk});
                options.setEnableActivityLifecycleBreadcrumbs(enableActivityLifecycleBreadcrumbs);
                boolean enableAppLifecycleBreadcrumbs = metadata.getBoolean(BREADCRUMBS_APP_LIFECYCLE_ENABLE, options.isEnableAppComponentBreadcrumbs());
                options.getLogger().log(SentryLevel.DEBUG, "enableAppLifecycleBreadcrumbs read: %s", new Object[]{ndk});
                options.setEnableAppLifecycleBreadcrumbs(enableAppLifecycleBreadcrumbs);
                boolean enableSystemEventBreadcrumbs = metadata.getBoolean(BREADCRUMBS_SYSTEM_EVENTS_ENABLE, options.isEnableSystemEventBreadcrumbs());
                options.getLogger().log(SentryLevel.DEBUG, "enableSystemEventBreadcrumbs read: %s", new Object[]{ndk});
                options.setEnableSystemEventBreadcrumbs(enableSystemEventBreadcrumbs);
                boolean enableAppComponentBreadcrumbs = metadata.getBoolean(BREADCRUMBS_APP_COMPONENTS_ENABLE, options.isEnableAppComponentBreadcrumbs());
                options.getLogger().log(SentryLevel.DEBUG, "enableAppComponentBreadcrumbs read: %s", new Object[]{ndk});
                options.setEnableAppComponentBreadcrumbs(enableAppComponentBreadcrumbs);
                boolean enableUncaughtExceptionHandler = metadata.getBoolean(UNCAUGHT_EXCEPTION_HANDLER_ENABLE, options.isEnableUncaughtExceptionHandler());
                options.getLogger().log(SentryLevel.DEBUG, "enableUncaughtExceptionHandler read: %s", new Object[]{ndk});
                options.setEnableUncaughtExceptionHandler(enableUncaughtExceptionHandler);
                boolean attachThreads = metadata.getBoolean(ATTACH_THREADS, options.isAttachThreads());
                options.getLogger().log(SentryLevel.DEBUG, "attachThreads read: %s", new Object[]{attachThreads});
                options.setAttachThreads(attachThreads);
            }
            options.getLogger().log(SentryLevel.INFO, "Retrieving configuration from AndroidManifest.xml", new Object[0]);
        }
        catch (Exception e) {
            options.getLogger().log(SentryLevel.ERROR, "Failed to read configuration from android manifest metadata.", (Throwable)e);
        }
    }

    static boolean isAutoInit(@NotNull Context context, @NotNull ILogger logger) {
        Objects.requireNonNull((Object)context, (String)"The application context is required.");
        boolean autoInit = true;
        try {
            Bundle metadata = ManifestMetadataReader.getMetadata(context);
            if (metadata != null) {
                autoInit = metadata.getBoolean(AUTO_INIT, true);
                logger.log(SentryLevel.DEBUG, "Auto-init: %s", new Object[]{autoInit});
            }
            logger.log(SentryLevel.INFO, "Retrieving auto-init from AndroidManifest.xml", new Object[0]);
        }
        catch (Exception e) {
            logger.log(SentryLevel.ERROR, "Failed to read auto-init from android manifest metadata.", (Throwable)e);
        }
        return autoInit;
    }

    @Nullable
    private static Bundle getMetadata(@NotNull Context context) throws PackageManager.NameNotFoundException {
        ApplicationInfo app = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
        return app.metaData;
    }
}

