/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.util.Log;
import io.sentry.ILogger;
import io.sentry.SentryLevel;

final class AndroidLogger
implements ILogger {
    private static final String tag = "Sentry";

    AndroidLogger() {
    }

    public void log(SentryLevel level, String message, Object ... args) {
        Log.println((int)this.toLogcatLevel(level), (String)tag, (String)String.format(message, args));
    }

    public void log(SentryLevel level, Throwable throwable, String message, Object ... args) {
        this.log(level, String.format(message, args), throwable);
    }

    public void log(SentryLevel level, String message, Throwable throwable) {
        switch (level) {
            case INFO: {
                Log.i((String)tag, (String)message, (Throwable)throwable);
                break;
            }
            case WARNING: {
                Log.w((String)tag, (String)message, (Throwable)throwable);
                break;
            }
            case ERROR: {
                Log.e((String)tag, (String)message, (Throwable)throwable);
                break;
            }
            case FATAL: {
                Log.wtf((String)tag, (String)message, (Throwable)throwable);
                break;
            }
            default: {
                Log.d((String)tag, (String)message, (Throwable)throwable);
            }
        }
    }

    private int toLogcatLevel(SentryLevel sentryLevel) {
        switch (sentryLevel) {
            case INFO: {
                return 4;
            }
            case WARNING: {
                return 5;
            }
            case FATAL: {
                return 7;
            }
        }
        return 3;
    }
}

