/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.content.Context;
import io.sentry.android.core.AndroidLogger;
import io.sentry.android.core.AndroidOptionsInitializer;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.core.ILogger;
import io.sentry.core.OptionsContainer;
import io.sentry.core.Sentry;
import io.sentry.core.SentryLevel;
import java.lang.reflect.InvocationTargetException;
import org.jetbrains.annotations.NotNull;

public final class SentryAndroid {
    private SentryAndroid() {
    }

    public static void init(@NotNull Context context) {
        SentryAndroid.init(context, new AndroidLogger());
    }

    public static void init(@NotNull Context context, @NotNull ILogger logger) {
        SentryAndroid.init(context, logger, (Sentry.OptionsConfiguration<SentryAndroidOptions>)((Sentry.OptionsConfiguration)options -> {}));
    }

    public static void init(@NotNull Context context, @NotNull Sentry.OptionsConfiguration<SentryAndroidOptions> configuration) {
        SentryAndroid.init(context, new AndroidLogger(), configuration);
    }

    public static void init(@NotNull Context context, @NotNull ILogger logger, @NotNull Sentry.OptionsConfiguration<SentryAndroidOptions> configuration) {
        try {
            Sentry.init((OptionsContainer)OptionsContainer.create(SentryAndroidOptions.class), options -> {
                AndroidOptionsInitializer.init(options, context, logger);
                configuration.configure(options);
            }, (boolean)true);
        }
        catch (IllegalAccessException e) {
            logger.log(SentryLevel.FATAL, "Fatal error during SentryAndroid.init(...)", (Throwable)e);
            throw new RuntimeException("Failed to initialize Sentry's SDK", e);
        }
        catch (InstantiationException e) {
            logger.log(SentryLevel.FATAL, "Fatal error during SentryAndroid.init(...)", (Throwable)e);
            throw new RuntimeException("Failed to initialize Sentry's SDK", e);
        }
        catch (NoSuchMethodException e) {
            logger.log(SentryLevel.FATAL, "Fatal error during SentryAndroid.init(...)", (Throwable)e);
            throw new RuntimeException("Failed to initialize Sentry's SDK", e);
        }
        catch (InvocationTargetException e) {
            logger.log(SentryLevel.FATAL, "Fatal error during SentryAndroid.init(...)", (Throwable)e);
            throw new RuntimeException("Failed to initialize Sentry's SDK", e);
        }
    }
}

