/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.content.Context;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import androidx.annotation.Nullable;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.util.Permissions;
import io.sentry.core.Breadcrumb;
import io.sentry.core.IHub;
import io.sentry.core.Integration;
import io.sentry.core.SentryLevel;
import io.sentry.core.SentryOptions;
import io.sentry.core.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class PhoneStateBreadcrumbsIntegration
implements Integration,
Closeable {
    @NotNull
    private final Context context;
    @Nullable
    private SentryAndroidOptions options;
    @TestOnly
    @Nullable
    PhoneStateChangeListener listener;
    @Nullable
    private TelephonyManager telephonyManager;

    public PhoneStateBreadcrumbsIntegration(@NotNull Context context) {
        this.context = (Context)Objects.requireNonNull((Object)context, (String)"Context is required");
    }

    public void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        Objects.requireNonNull((Object)hub, (String)"Hub is required");
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)(options instanceof SentryAndroidOptions ? (SentryAndroidOptions)options : null)), (String)"SentryAndroidOptions is required"));
        this.options.getLogger().log(SentryLevel.DEBUG, "enableSystemEventBreadcrumbs enabled: %s", new Object[]{this.options.isEnableSystemEventBreadcrumbs()});
        if (this.options.isEnableSystemEventBreadcrumbs() && Permissions.hasPermission(this.context, "android.permission.READ_PHONE_STATE")) {
            this.telephonyManager = (TelephonyManager)this.context.getSystemService("phone");
            if (this.telephonyManager != null) {
                try {
                    this.listener = new PhoneStateChangeListener(hub);
                    this.telephonyManager.listen((PhoneStateListener)this.listener, 32);
                    options.getLogger().log(SentryLevel.DEBUG, "PhoneStateBreadcrumbsIntegration installed.", new Object[0]);
                }
                catch (Exception e) {
                    this.options.getLogger().log(SentryLevel.INFO, (Throwable)e, "TelephonyManager is not available or ready to use.", new Object[0]);
                }
            } else {
                this.options.getLogger().log(SentryLevel.INFO, "TelephonyManager is not available", new Object[0]);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.telephonyManager != null && this.listener != null) {
            this.telephonyManager.listen((PhoneStateListener)this.listener, 0);
            this.listener = null;
            if (this.options != null) {
                this.options.getLogger().log(SentryLevel.DEBUG, "PhoneStateBreadcrumbsIntegration removed.", new Object[0]);
            }
        }
    }

    static final class PhoneStateChangeListener
    extends PhoneStateListener {
        @NotNull
        private final IHub hub;

        PhoneStateChangeListener(@NotNull IHub hub) {
            this.hub = hub;
        }

        public void onCallStateChanged(int state, String incomingNumber) {
            if (state == 1) {
                Breadcrumb breadcrumb = new Breadcrumb();
                breadcrumb.setType("system");
                breadcrumb.setCategory("device.event");
                breadcrumb.setData("action", (Object)"CALL_STATE_RINGING");
                breadcrumb.setMessage("Device ringing");
                breadcrumb.setLevel(SentryLevel.INFO);
                this.hub.addBreadcrumb(breadcrumb);
            }
        }
    }
}

