/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.ProcessLifecycleOwner;
import io.sentry.android.core.IHandler;
import io.sentry.android.core.LifecycleWatcher;
import io.sentry.android.core.MainLooperHandler;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.util.MainThreadChecker;
import io.sentry.core.IHub;
import io.sentry.core.Integration;
import io.sentry.core.SentryLevel;
import io.sentry.core.SentryOptions;
import io.sentry.core.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class AppLifecycleIntegration
implements Integration,
Closeable {
    @TestOnly
    @Nullable
    LifecycleWatcher watcher;
    @Nullable
    private SentryAndroidOptions options;
    @NotNull
    private final IHandler handler;

    public AppLifecycleIntegration() {
        this(new MainLooperHandler());
    }

    AppLifecycleIntegration(@NotNull IHandler handler) {
        this.handler = handler;
    }

    public void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        Objects.requireNonNull((Object)hub, (String)"Hub is required");
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)(options instanceof SentryAndroidOptions ? (SentryAndroidOptions)options : null)), (String)"SentryAndroidOptions is required"));
        this.options.getLogger().log(SentryLevel.DEBUG, "enableSessionTracking enabled: %s", new Object[]{this.options.isEnableSessionTracking()});
        this.options.getLogger().log(SentryLevel.DEBUG, "enableAppLifecycleBreadcrumbs enabled: %s", new Object[]{this.options.isEnableAppLifecycleBreadcrumbs()});
        if (this.options.isEnableSessionTracking() || this.options.isEnableAppLifecycleBreadcrumbs()) {
            try {
                Class.forName("androidx.lifecycle.DefaultLifecycleObserver");
                Class.forName("androidx.lifecycle.ProcessLifecycleOwner");
                if (MainThreadChecker.isMainThread()) {
                    this.addObserver(hub);
                } else {
                    this.handler.post(() -> this.addObserver(hub));
                }
            }
            catch (ClassNotFoundException e) {
                options.getLogger().log(SentryLevel.INFO, "androidx.lifecycle is not available, AppLifecycleIntegration won't be installed", (Throwable)e);
            }
            catch (IllegalStateException e) {
                options.getLogger().log(SentryLevel.ERROR, "AppLifecycleIntegration could not be installed", (Throwable)e);
            }
        }
    }

    private void addObserver(@NotNull IHub hub) {
        this.watcher = new LifecycleWatcher(hub, this.options.getSessionTrackingIntervalMillis(), this.options.isEnableSessionTracking(), this.options.isEnableAppLifecycleBreadcrumbs());
        ProcessLifecycleOwner.get().getLifecycle().addObserver((LifecycleObserver)this.watcher);
        this.options.getLogger().log(SentryLevel.DEBUG, "AppLifecycleIntegration installed.", new Object[0]);
    }

    @Override
    public void close() throws IOException {
        if (this.watcher != null) {
            ProcessLifecycleOwner.get().getLifecycle().removeObserver((LifecycleObserver)this.watcher);
            this.watcher = null;
            if (this.options != null) {
                this.options.getLogger().log(SentryLevel.DEBUG, "AppLifecycleIntegration removed.", new Object[0]);
            }
        }
    }
}

