/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.content.Context;
import io.sentry.android.core.util.ConnectivityChecker;
import io.sentry.core.ILogger;
import io.sentry.core.transport.ITransportGate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

final class AndroidTransportGate
implements ITransportGate {
    private final Context context;
    @NotNull
    private final ILogger logger;

    AndroidTransportGate(@NotNull Context context, @NotNull ILogger logger) {
        this.context = context;
        this.logger = logger;
    }

    public boolean isConnected() {
        return this.isConnected(ConnectivityChecker.getConnectionStatus(this.context, this.logger));
    }

    @TestOnly
    boolean isConnected(@NotNull ConnectivityChecker.Status status) {
        switch (status) {
            case CONNECTED: 
            case UNKNOWN: 
            case NO_PERMISSION: {
                return true;
            }
        }
        return false;
    }
}

