/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import io.sentry.core.IHub;
import io.sentry.core.Integration;
import io.sentry.core.SentryLevel;
import io.sentry.core.SentryOptions;
import io.sentry.core.util.Objects;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NdkIntegration
implements Integration {
    public static final String SENTRY_NDK_CLASS_NAME = "io.sentry.android.ndk.SentryNdk";
    @Nullable
    private final Class<?> sentryNdkClass;

    public NdkIntegration(@Nullable Class<?> sentryNdkClass) {
        this.sentryNdkClass = sentryNdkClass;
    }

    public final void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        Objects.requireNonNull((Object)hub, (String)"Hub is required");
        Objects.requireNonNull((Object)options, (String)"SentryOptions is required");
        boolean enabled = options.isEnableNdk();
        options.getLogger().log(SentryLevel.DEBUG, "NdkIntegration enabled: %s", new Object[]{enabled});
        if (enabled && this.sentryNdkClass != null) {
            try {
                Method method = this.sentryNdkClass.getMethod("init", SentryOptions.class);
                Object[] args = new Object[]{options};
                method.invoke(null, args);
                options.getLogger().log(SentryLevel.DEBUG, "NdkIntegration installed.", new Object[0]);
            }
            catch (NoSuchMethodException e) {
                options.setEnableNdk(false);
                options.getLogger().log(SentryLevel.ERROR, "Failed to invoke the SentryNdk.init method.", (Throwable)e);
            }
            catch (Throwable e) {
                options.setEnableNdk(false);
                options.getLogger().log(SentryLevel.ERROR, "Failed to initialize SentryNdk.", e);
            }
        } else {
            options.setEnableNdk(false);
        }
    }

    @Nullable
    Class<?> getSentryNdkClass() {
        return this.sentryNdkClass;
    }
}

