/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.adapters;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.sentry.core.ILogger;
import io.sentry.core.SentryLevel;
import io.sentry.core.protocol.App;
import io.sentry.core.protocol.Browser;
import io.sentry.core.protocol.Contexts;
import io.sentry.core.protocol.Device;
import io.sentry.core.protocol.Gpu;
import io.sentry.core.protocol.OperatingSystem;
import io.sentry.core.protocol.SentryRuntime;
import java.lang.reflect.Type;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ContextsDeserializerAdapter
implements JsonDeserializer<Contexts> {
    @NotNull
    private final ILogger logger;

    public ContextsDeserializerAdapter(@NotNull ILogger logger) {
        this.logger = logger;
    }

    public Contexts deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        try {
            if (json != null && !json.isJsonNull()) {
                Contexts contexts = new Contexts();
                JsonObject jsonObject = json.getAsJsonObject();
                if (jsonObject != null && !jsonObject.isJsonNull()) {
                    JsonObject gpuObject;
                    JsonObject runtimeObject;
                    JsonObject osObject;
                    JsonObject deviceObject;
                    JsonObject browserObject;
                    JsonObject appOjbect = jsonObject.getAsJsonObject("app");
                    if (appOjbect != null && !appOjbect.isJsonNull()) {
                        App app = (App)context.deserialize((JsonElement)appOjbect, App.class);
                        contexts.setApp(app);
                    }
                    if ((browserObject = jsonObject.getAsJsonObject("browser")) != null && !browserObject.isJsonNull()) {
                        Browser browser = (Browser)context.deserialize((JsonElement)browserObject, Browser.class);
                        contexts.setBrowser(browser);
                    }
                    if ((deviceObject = jsonObject.getAsJsonObject("device")) != null && !deviceObject.isJsonNull()) {
                        Device device = (Device)context.deserialize((JsonElement)deviceObject, Device.class);
                        contexts.setDevice(device);
                    }
                    if ((osObject = jsonObject.getAsJsonObject("os")) != null && !osObject.isJsonNull()) {
                        OperatingSystem os = (OperatingSystem)context.deserialize((JsonElement)osObject, OperatingSystem.class);
                        contexts.setOperatingSystem(os);
                    }
                    if ((runtimeObject = jsonObject.getAsJsonObject("runtime")) != null && !runtimeObject.isJsonNull()) {
                        SentryRuntime runtime = (SentryRuntime)context.deserialize((JsonElement)runtimeObject, SentryRuntime.class);
                        contexts.setRuntime(runtime);
                    }
                    if ((gpuObject = jsonObject.getAsJsonObject("gpu")) != null && !gpuObject.isJsonNull()) {
                        Gpu gpu = (Gpu)context.deserialize((JsonElement)runtimeObject, Gpu.class);
                        contexts.setGpu(gpu);
                    }
                }
                return contexts;
            }
        }
        catch (Exception e) {
            this.logger.log(SentryLevel.ERROR, "Error when deserializing Contexts", (Throwable)e);
        }
        return null;
    }
}

