/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.util.DeviceOrientations;
import io.sentry.core.Breadcrumb;
import io.sentry.core.IHub;
import io.sentry.core.Integration;
import io.sentry.core.SentryLevel;
import io.sentry.core.SentryOptions;
import io.sentry.core.protocol.Device;
import io.sentry.core.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public final class AppComponentsBreadcrumbsIntegration
implements Integration,
Closeable,
ComponentCallbacks2 {
    @NotNull
    private final Context context;
    @Nullable
    private IHub hub;
    @Nullable
    private SentryAndroidOptions options;

    public AppComponentsBreadcrumbsIntegration(@NotNull Context context) {
        this.context = (Context)Objects.requireNonNull((Object)context, (String)"Context is required");
    }

    public void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"Hub is required");
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)(options instanceof SentryAndroidOptions ? (SentryAndroidOptions)options : null)), (String)"SentryAndroidOptions is required"));
        this.options.getLogger().log(SentryLevel.DEBUG, "AppComponentsBreadcrumbsIntegration enabled: %s", new Object[]{this.options.isEnableAppComponentBreadcrumbs()});
        if (this.options.isEnableAppComponentBreadcrumbs()) {
            this.context.registerComponentCallbacks((ComponentCallbacks)this);
            options.getLogger().log(SentryLevel.DEBUG, "AppComponentsBreadcrumbsIntegration installed.", new Object[0]);
        }
    }

    @Override
    public void close() throws IOException {
        this.context.unregisterComponentCallbacks((ComponentCallbacks)this);
        if (this.options != null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "AppComponentsBreadcrumbsIntegration removed.", new Object[0]);
        }
    }

    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        if (this.hub != null) {
            Device.DeviceOrientation deviceOrientation = DeviceOrientations.getOrientation(this.context.getResources().getConfiguration().orientation);
            String orientation = deviceOrientation != null ? deviceOrientation.name().toLowerCase(Locale.ROOT) : "undefined";
            Breadcrumb breadcrumb = new Breadcrumb();
            breadcrumb.setType("navigation");
            breadcrumb.setCategory("device.orientation");
            breadcrumb.setData("position", (Object)orientation);
            breadcrumb.setLevel(SentryLevel.INFO);
            this.hub.addBreadcrumb(breadcrumb);
        }
    }

    public void onLowMemory() {
        this.createLowMemoryBreadcrumb(null);
    }

    public void onTrimMemory(int level) {
        this.createLowMemoryBreadcrumb(level);
    }

    private void createLowMemoryBreadcrumb(@Nullable Integer level) {
        if (this.hub != null) {
            Breadcrumb breadcrumb = new Breadcrumb();
            breadcrumb.setType("system");
            breadcrumb.setCategory("device.event");
            breadcrumb.setMessage("Low memory");
            breadcrumb.setData("action", (Object)"LOW_MEMORY");
            if (level != null) {
                breadcrumb.setData("level", (Object)level);
            }
            breadcrumb.setLevel(SentryLevel.WARNING);
            this.hub.addBreadcrumb(breadcrumb);
        }
    }
}

