/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import io.sentry.core.IHub;
import java.util.Timer;
import java.util.TimerTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LifecycleWatcher
implements DefaultLifecycleObserver {
    private long lastStartedSession = 0L;
    private final long sessionIntervalMillis;
    @Nullable
    private TimerTask timerTask;
    @NotNull
    private final Timer timer = new Timer(true);
    @NotNull
    private final IHub hub;

    LifecycleWatcher(@NotNull IHub hub, long sessionIntervalMillis) {
        this.sessionIntervalMillis = sessionIntervalMillis;
        this.hub = hub;
    }

    public void onStart(@NotNull LifecycleOwner owner) {
        long currentTimeMillis = System.currentTimeMillis();
        this.cancelTask();
        if (this.lastStartedSession == 0L || this.lastStartedSession + this.sessionIntervalMillis <= currentTimeMillis) {
            this.hub.startSession();
        }
        this.lastStartedSession = currentTimeMillis;
    }

    public void onStop(@NotNull LifecycleOwner owner) {
        this.scheduleEndSession();
    }

    private void scheduleEndSession() {
        this.cancelTask();
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                LifecycleWatcher.this.hub.endSession();
            }
        };
        this.timer.schedule(this.timerTask, this.sessionIntervalMillis);
    }

    private void cancelTask() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
    }
}

