/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import io.sentry.android.core.util.Permissions;
import io.sentry.core.ILogger;
import io.sentry.core.SentryLevel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ConnectivityChecker {
    private ConnectivityChecker() {
    }

    @Nullable
    public static Boolean isConnected(@NotNull Context context, @NotNull ILogger logger) {
        ConnectivityManager connectivityManager = ConnectivityChecker.getConnectivityManager(context, logger);
        if (connectivityManager == null) {
            return null;
        }
        return ConnectivityChecker.isConnected(context, connectivityManager, logger);
    }

    private static Boolean isConnected(Context context, ConnectivityManager connectivityManager, ILogger logger) {
        NetworkInfo activeNetwork = ConnectivityChecker.getActiveNetworkInfo(context, connectivityManager, logger);
        if (activeNetwork == null) {
            logger.log(SentryLevel.INFO, "NetworkInfo is null and cannot check network status", new Object[0]);
            return null;
        }
        return activeNetwork.isConnected();
    }

    @Nullable
    private static NetworkInfo getActiveNetworkInfo(@NotNull Context context, @NotNull ConnectivityManager connectivityManager, @NotNull ILogger logger) {
        if (!Permissions.hasPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
            logger.log(SentryLevel.INFO, "No permission (ACCESS_NETWORK_STATE) to check network status.", new Object[0]);
            return null;
        }
        return connectivityManager.getActiveNetworkInfo();
    }

    @SuppressLint(value={"ObsoleteSdkInt", "MissingPermission"})
    public static String getConnectionType(@NotNull Context context, @NotNull ILogger logger) {
        if (Build.VERSION.SDK_INT >= 23) {
            ConnectivityManager connectivityManager = ConnectivityChecker.getConnectivityManager(context, logger);
            if (connectivityManager == null) {
                return null;
            }
            if (!Permissions.hasPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
                logger.log(SentryLevel.INFO, "No permission (ACCESS_NETWORK_STATE) to check network status.", new Object[0]);
                return null;
            }
            Network activeNetwork = connectivityManager.getActiveNetwork();
            if (activeNetwork == null) {
                logger.log(SentryLevel.INFO, "Network is null and cannot check network status", new Object[0]);
                return null;
            }
            NetworkCapabilities networkCapabilities = connectivityManager.getNetworkCapabilities(activeNetwork);
            if (networkCapabilities == null) {
                logger.log(SentryLevel.INFO, "NetworkCapabilities is null and cannot check network type", new Object[0]);
                return null;
            }
            if (networkCapabilities.hasTransport(1)) {
                return "wifi";
            }
            if (networkCapabilities.hasTransport(3)) {
                return "ethernet";
            }
            if (networkCapabilities.hasTransport(3)) {
                return "cellular";
            }
        }
        return null;
    }

    @Nullable
    private static ConnectivityManager getConnectivityManager(@NotNull Context context, @NotNull ILogger logger) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager == null) {
            logger.log(SentryLevel.INFO, "ConnectivityManager is null and cannot check network status", new Object[0]);
        }
        return connectivityManager;
    }
}

