/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.ProcessLifecycleOwner;
import io.sentry.android.core.LifecycleWatcher;
import io.sentry.core.IHub;
import io.sentry.core.Integration;
import io.sentry.core.SentryLevel;
import io.sentry.core.SentryOptions;
import io.sentry.core.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SessionTrackingIntegration
implements Integration,
Closeable {
    @Nullable
    LifecycleWatcher watcher;
    @Nullable
    private SentryOptions options;

    public void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        this.options = (SentryOptions)Objects.requireNonNull((Object)options, (String)"SentryOptions is required");
        Objects.requireNonNull((Object)hub, (String)"Hub is required");
        options.getLogger().log(SentryLevel.DEBUG, "SessionTrackingIntegration enabled: %s", new Object[]{options.isEnableSessionTracking()});
        if (options.isEnableSessionTracking()) {
            this.watcher = new LifecycleWatcher(hub, options.getSessionTrackingIntervalMillis());
            ProcessLifecycleOwner.get().getLifecycle().addObserver((LifecycleObserver)this.watcher);
            options.getLogger().log(SentryLevel.DEBUG, "SessionTrackingIntegration installed.", new Object[0]);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.watcher != null) {
            ProcessLifecycleOwner.get().getLifecycle().removeObserver((LifecycleObserver)this.watcher);
            this.watcher = null;
            if (this.options != null) {
                this.options.getLogger().log(SentryLevel.DEBUG, "SessionTrackingIntegration removed.", new Object[0]);
            }
        }
    }
}

