/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import io.sentry.core.Breadcrumb;
import io.sentry.core.IHub;
import io.sentry.core.SentryLevel;
import java.util.Timer;
import java.util.TimerTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LifecycleWatcher
implements DefaultLifecycleObserver {
    private long lastStartedSession = 0L;
    private final long sessionIntervalMillis;
    @Nullable
    private TimerTask timerTask;
    @NotNull
    private final Timer timer = new Timer(true);
    @NotNull
    private final IHub hub;
    private final boolean enableSessionTracking;
    private final boolean enableAppLifecycleBreadcrumbs;

    LifecycleWatcher(@NotNull IHub hub, long sessionIntervalMillis, boolean enableSessionTracking, boolean enableAppLifecycleBreadcrumbs) {
        this.sessionIntervalMillis = sessionIntervalMillis;
        this.enableSessionTracking = enableSessionTracking;
        this.enableAppLifecycleBreadcrumbs = enableAppLifecycleBreadcrumbs;
        this.hub = hub;
    }

    public void onStart(@NotNull LifecycleOwner owner) {
        this.startSession();
        this.addAppBreadcrumb("foreground");
    }

    private void startSession() {
        if (this.enableSessionTracking) {
            long currentTimeMillis = System.currentTimeMillis();
            this.cancelTask();
            if (this.lastStartedSession == 0L || this.lastStartedSession + this.sessionIntervalMillis <= currentTimeMillis) {
                this.addSessionBreadcrumb("start");
                this.hub.startSession();
            }
            this.lastStartedSession = currentTimeMillis;
        }
    }

    public void onStop(@NotNull LifecycleOwner owner) {
        if (this.enableSessionTracking) {
            this.scheduleEndSession();
        }
        this.addAppBreadcrumb("background");
    }

    private void scheduleEndSession() {
        this.cancelTask();
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                LifecycleWatcher.this.addSessionBreadcrumb("end");
                LifecycleWatcher.this.hub.endSession();
            }
        };
        this.timer.schedule(this.timerTask, this.sessionIntervalMillis);
    }

    private void cancelTask() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
    }

    private void addAppBreadcrumb(@NotNull String state) {
        if (this.enableAppLifecycleBreadcrumbs) {
            Breadcrumb breadcrumb = new Breadcrumb();
            breadcrumb.setType("navigation");
            breadcrumb.setData("state", (Object)state);
            breadcrumb.setCategory("app.lifecycle");
            breadcrumb.setLevel(SentryLevel.INFO);
            this.hub.addBreadcrumb(breadcrumb);
        }
    }

    private void addSessionBreadcrumb(@NotNull String state) {
        Breadcrumb breadcrumb = new Breadcrumb();
        breadcrumb.setType("session");
        breadcrumb.setData("state", (Object)state);
        breadcrumb.setCategory("app.lifecycle");
        breadcrumb.setLevel(SentryLevel.INFO);
        this.hub.addBreadcrumb(breadcrumb);
    }
}

