/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.res.AssetManager;
import android.os.Build;
import android.os.Environment;
import android.os.LocaleList;
import android.os.Looper;
import android.os.StatFs;
import android.os.SystemClock;
import android.provider.Settings;
import android.util.DisplayMetrics;
import io.sentry.android.core.ContextUtils;
import io.sentry.android.core.Installation;
import io.sentry.android.core.util.ConnectivityChecker;
import io.sentry.android.core.util.DeviceOrientations;
import io.sentry.core.DateUtils;
import io.sentry.core.EventProcessor;
import io.sentry.core.SentryEvent;
import io.sentry.core.SentryLevel;
import io.sentry.core.SentryOptions;
import io.sentry.core.protocol.App;
import io.sentry.core.protocol.DebugImage;
import io.sentry.core.protocol.DebugMeta;
import io.sentry.core.protocol.Device;
import io.sentry.core.protocol.OperatingSystem;
import io.sentry.core.protocol.SdkVersion;
import io.sentry.core.protocol.SentryThread;
import io.sentry.core.protocol.User;
import io.sentry.core.util.ApplyScopeUtils;
import io.sentry.core.util.Objects;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DefaultAndroidEventProcessor
implements EventProcessor {
    static final String PROGUARD_UUID = "proGuardUuids";
    static final String ROOTED = "rooted";
    static final String ANDROID_ID = "androidId";
    static final String KERNEL_VERSION = "kernelVersion";
    static final String EMULATOR = "emulator";
    private static final Date appStartTime = DateUtils.getCurrentDateTime();
    final Context context;
    private final SentryOptions options;
    final Future<Map<String, Object>> contextData;

    public DefaultAndroidEventProcessor(@NotNull Context context, @NotNull SentryOptions options) {
        this.context = (Context)Objects.requireNonNull((Object)context, (String)"The application context is required.");
        this.options = (SentryOptions)Objects.requireNonNull((Object)options, (String)"The SentryOptions is required.");
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        this.contextData = executorService.submit(() -> this.loadContextData());
        executorService.shutdown();
    }

    @NotNull
    private Map<String, Object> loadContextData() {
        String kernelVersion;
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] proGuardUuids = this.getProGuardUuids();
        if (proGuardUuids != null) {
            map.put(PROGUARD_UUID, proGuardUuids);
        }
        map.put(ROOTED, this.isRooted());
        String androidId = this.getAndroidId();
        if (androidId != null) {
            map.put(ANDROID_ID, androidId);
        }
        if ((kernelVersion = this.getKernelVersion()) != null) {
            map.put(KERNEL_VERSION, kernelVersion);
        }
        map.put(EMULATOR, this.isEmulator());
        return map;
    }

    @NotNull
    public SentryEvent process(@NotNull SentryEvent event, @Nullable Object hint) {
        if (ApplyScopeUtils.shouldApplyScopeData((Object)hint)) {
            this.processNonCachedEvent(event);
        } else {
            this.options.getLogger().log(SentryLevel.DEBUG, "Event was cached so not applying data relevant to the current app execution/version: %s", new Object[]{event.getEventId()});
        }
        if (event.getContexts().getDevice() == null) {
            event.getContexts().setDevice(this.getDevice());
        }
        if (event.getContexts().getOperatingSystem() == null) {
            event.getContexts().setOperatingSystem(this.getOperatingSystem());
        }
        return event;
    }

    private void processNonCachedEvent(@NotNull SentryEvent event) {
        PackageInfo packageInfo;
        App app;
        if (event.getUser() == null) {
            event.setUser(this.getUser());
        }
        if ((app = event.getContexts().getApp()) == null) {
            app = new App();
        }
        this.setAppExtras(app);
        if (event.getDebugMeta() == null) {
            event.setDebugMeta(this.getDebugMeta());
        }
        if (event.getSdk() == null) {
            event.setSdk(this.getSdkVersion());
        }
        if ((packageInfo = ContextUtils.getPackageInfo(this.context, this.options.getLogger())) != null) {
            String versionCode = ContextUtils.getVersionCode(packageInfo);
            if (event.getDist() == null) {
                event.setDist(versionCode);
            }
            this.setAppPackageInfo(app, packageInfo);
        }
        event.getContexts().setApp(app);
        if (event.getThreads() != null) {
            for (SentryThread thread : event.getThreads()) {
                thread.setCurrent(Boolean.valueOf(Looper.getMainLooper().getThread().getId() == thread.getId().longValue()));
            }
        }
    }

    @Nullable
    private List<DebugImage> getDebugImages() {
        String[] uuids = null;
        try {
            Object proGuardUuids = this.contextData.get().get(PROGUARD_UUID);
            if (proGuardUuids != null) {
                uuids = (String[])proGuardUuids;
            }
        }
        catch (Exception e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error getting proGuardUuids.", (Throwable)e);
            return null;
        }
        if (uuids == null || uuids.length == 0) {
            return null;
        }
        ArrayList<DebugImage> images = new ArrayList<DebugImage>();
        for (String item : uuids) {
            DebugImage debugImage = new DebugImage();
            debugImage.setType("proguard");
            debugImage.setUuid(item);
            images.add(debugImage);
        }
        return images;
    }

    @Nullable
    private DebugMeta getDebugMeta() {
        List<DebugImage> debugImages = this.getDebugImages();
        if (debugImages == null) {
            return null;
        }
        DebugMeta debugMeta = new DebugMeta();
        debugMeta.setImages(debugImages);
        return debugMeta;
    }

    private void setAppExtras(@NotNull App app) {
        app.setAppName(this.getApplicationName());
        app.setAppStartTime(appStartTime);
    }

    @NotNull
    private SdkVersion getSdkVersion() {
        SdkVersion sdkVersion = new SdkVersion();
        sdkVersion.setName("sentry.java.android");
        String version = "2.1.0-RC.1";
        sdkVersion.setVersion(version);
        sdkVersion.addPackage("maven:sentry-core", version);
        sdkVersion.addPackage("maven:sentry-android-core", version);
        if (this.options.isEnableNdk()) {
            sdkVersion.addPackage("maven:sentry-android-ndk", version);
        }
        return sdkVersion;
    }

    @NotNull
    private String getAbi() {
        return Build.CPU_ABI;
    }

    @NotNull
    private String getAbi2() {
        return Build.CPU_ABI2;
    }

    private void setArchitectures(@NotNull Device device) {
        if (Build.VERSION.SDK_INT >= 21) {
            String[] supportedAbis = Build.SUPPORTED_ABIS;
            device.setArch(supportedAbis[0]);
            device.setArchs(supportedAbis);
        } else {
            String[] supportedAbis = new String[]{this.getAbi(), this.getAbi2()};
            device.setArch(supportedAbis[0]);
            device.setArchs(supportedAbis);
        }
    }

    @NotNull
    private Long getMemorySize(@NotNull ActivityManager.MemoryInfo memInfo) {
        if (Build.VERSION.SDK_INT >= 16) {
            return memInfo.totalMem;
        }
        return Runtime.getRuntime().totalMemory();
    }

    @NotNull
    private Device getDevice() {
        DisplayMetrics displayMetrics;
        StatFs externalStorageStat;
        File internalStorageFile;
        Device device = new Device();
        device.setName(this.getDeviceName());
        device.setManufacturer(Build.MANUFACTURER);
        device.setBrand(Build.BRAND);
        device.setFamily(this.getFamily());
        device.setModel(Build.MODEL);
        device.setModelId(Build.ID);
        this.setArchitectures(device);
        Intent batteryIntent = this.getBatteryIntent();
        if (batteryIntent != null) {
            device.setBatteryLevel(this.getBatteryLevel(batteryIntent));
            device.setCharging(this.isCharging(batteryIntent));
            device.setBatteryTemperature(this.getBatteryTemperature(batteryIntent));
        }
        device.setOnline(ConnectivityChecker.isConnected(this.context, this.options.getLogger()));
        device.setOrientation(this.getOrientation());
        try {
            Object emulator = this.contextData.get().get(EMULATOR);
            if (emulator != null) {
                device.setSimulator((Boolean)emulator);
            }
        }
        catch (Exception e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error getting emulator.", (Throwable)e);
        }
        ActivityManager.MemoryInfo memInfo = this.getMemInfo();
        if (memInfo != null) {
            device.setMemorySize(this.getMemorySize(memInfo));
            device.setFreeMemory(Long.valueOf(memInfo.availMem));
            device.setLowMemory(Boolean.valueOf(memInfo.lowMemory));
        }
        if ((internalStorageFile = this.context.getExternalFilesDir(null)) != null) {
            StatFs internalStorageStat = new StatFs(internalStorageFile.getPath());
            device.setStorageSize(this.getTotalInternalStorage(internalStorageStat));
            device.setFreeStorage(this.getUnusedInternalStorage(internalStorageStat));
        }
        if ((externalStorageStat = this.getExternalStorageStat(internalStorageFile)) != null) {
            device.setExternalStorageSize(this.getTotalExternalStorage(externalStorageStat));
            device.setExternalFreeStorage(this.getUnusedExternalStorage(externalStorageStat));
        }
        if ((displayMetrics = this.getDisplayMetrics()) != null) {
            this.setScreenResolution(device, displayMetrics);
            device.setScreenWidthPixels(Integer.valueOf(displayMetrics.widthPixels));
            device.setScreenHeightPixels(Integer.valueOf(displayMetrics.heightPixels));
            device.setScreenDensity(Float.valueOf(displayMetrics.density));
            device.setScreenDpi(Integer.valueOf(displayMetrics.densityDpi));
        }
        device.setBootTime(this.getBootTime());
        device.setTimezone(this.getTimeZone());
        if (device.getId() == null) {
            device.setId(this.getDeviceId());
        }
        if (device.getLanguage() == null) {
            device.setLanguage(Locale.getDefault().toString());
        }
        if (device.getConnectionType() == null) {
            device.setConnectionType(ConnectivityChecker.getConnectionType(this.context, this.options.getLogger()));
        }
        return device;
    }

    @Nullable
    private String getDeviceName() {
        if (Build.VERSION.SDK_INT >= 17) {
            return Settings.Global.getString((ContentResolver)this.context.getContentResolver(), (String)"device_name");
        }
        return null;
    }

    private void setScreenResolution(@NotNull Device device, @NotNull DisplayMetrics displayMetrics) {
        device.setScreenResolution(this.getResolution(displayMetrics));
    }

    private TimeZone getTimeZone() {
        LocaleList locales;
        if (Build.VERSION.SDK_INT >= 24 && !(locales = this.context.getResources().getConfiguration().getLocales()).isEmpty()) {
            Locale locale = locales.get(0);
            return Calendar.getInstance(locale).getTimeZone();
        }
        return Calendar.getInstance().getTimeZone();
    }

    @NotNull
    private Date getBootTime() {
        return DateUtils.getDateTime((Date)new Date(System.currentTimeMillis() - SystemClock.elapsedRealtime()));
    }

    @NotNull
    private String getResolution(@NotNull DisplayMetrics displayMetrics) {
        int largestSide = Math.max(displayMetrics.widthPixels, displayMetrics.heightPixels);
        int smallestSide = Math.min(displayMetrics.widthPixels, displayMetrics.heightPixels);
        return largestSide + "x" + smallestSide;
    }

    @Nullable
    private ActivityManager.MemoryInfo getMemInfo() {
        try {
            ActivityManager actManager = (ActivityManager)this.context.getSystemService("activity");
            ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
            if (actManager != null) {
                actManager.getMemoryInfo(memInfo);
                return memInfo;
            }
            this.options.getLogger().log(SentryLevel.INFO, "Error getting MemoryInfo.", new Object[0]);
            return null;
        }
        catch (Exception e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error getting MemoryInfo.", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private Intent getBatteryIntent() {
        return this.context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
    }

    @Nullable
    private String getFamily() {
        try {
            return Build.MODEL.split(" ", -1)[0];
        }
        catch (Exception e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error getting device family.", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private Float getBatteryLevel(@NotNull Intent batteryIntent) {
        try {
            int level = batteryIntent.getIntExtra("level", -1);
            int scale = batteryIntent.getIntExtra("scale", -1);
            if (level == -1 || scale == -1) {
                return null;
            }
            float percentMultiplier = 100.0f;
            return Float.valueOf((float)level / (float)scale * percentMultiplier);
        }
        catch (Exception e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error getting device battery level.", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private Boolean isCharging(@NotNull Intent batteryIntent) {
        try {
            int plugged = batteryIntent.getIntExtra("plugged", -1);
            return plugged == 1 || plugged == 2;
        }
        catch (Exception e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error getting device charging state.", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private Float getBatteryTemperature(@NotNull Intent batteryIntent) {
        try {
            int temperature = batteryIntent.getIntExtra("temperature", -1);
            if (temperature != -1) {
                return Float.valueOf((float)temperature / 10.0f);
            }
        }
        catch (Exception e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error getting battery temperature.", (Throwable)e);
        }
        return null;
    }

    @Nullable
    private Device.DeviceOrientation getOrientation() {
        Device.DeviceOrientation deviceOrientation = null;
        try {
            deviceOrientation = DeviceOrientations.getOrientation(this.context.getResources().getConfiguration().orientation);
            if (deviceOrientation == null) {
                this.options.getLogger().log(SentryLevel.INFO, "No device orientation available (ORIENTATION_SQUARE|ORIENTATION_UNDEFINED)", new Object[0]);
                return null;
            }
        }
        catch (Exception e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error getting device orientation.", (Throwable)e);
        }
        return deviceOrientation;
    }

    @Nullable
    private Boolean isEmulator() {
        try {
            return Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic") || Build.FINGERPRINT.startsWith("generic") || Build.FINGERPRINT.startsWith("unknown") || Build.HARDWARE.contains("goldfish") || Build.HARDWARE.contains("ranchu") || Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK built for x86") || Build.MANUFACTURER.contains("Genymotion") || Build.PRODUCT.contains("sdk_google") || Build.PRODUCT.contains("google_sdk") || Build.PRODUCT.contains("sdk") || Build.PRODUCT.contains("sdk_x86") || Build.PRODUCT.contains("vbox86p") || Build.PRODUCT.contains(EMULATOR) || Build.PRODUCT.contains("simulator");
        }
        catch (Exception e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error checking whether application is running in an emulator.", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private Long getTotalInternalStorage(@NotNull StatFs stat) {
        try {
            long blockSize = this.getBlockSizeLong(stat);
            long totalBlocks = this.getBlockCountLong(stat);
            return totalBlocks * blockSize;
        }
        catch (Exception e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error getting total internal storage amount.", (Throwable)e);
            return null;
        }
    }

    private long getBlockSizeLong(@NotNull StatFs stat) {
        if (Build.VERSION.SDK_INT >= 18) {
            return stat.getBlockSizeLong();
        }
        return this.getBlockSizeDep(stat);
    }

    private int getBlockSizeDep(@NotNull StatFs stat) {
        return stat.getBlockSize();
    }

    private long getBlockCountLong(@NotNull StatFs stat) {
        if (Build.VERSION.SDK_INT >= 18) {
            return stat.getBlockCountLong();
        }
        return this.getBlockCountDep(stat);
    }

    private int getBlockCountDep(@NotNull StatFs stat) {
        return stat.getBlockCount();
    }

    private long getAvailableBlocksLong(@NotNull StatFs stat) {
        if (Build.VERSION.SDK_INT >= 18) {
            return stat.getAvailableBlocksLong();
        }
        return this.getAvailableBlocksDep(stat);
    }

    private int getAvailableBlocksDep(@NotNull StatFs stat) {
        return stat.getAvailableBlocks();
    }

    @Nullable
    private Long getUnusedInternalStorage(@NotNull StatFs stat) {
        try {
            long blockSize = this.getBlockSizeLong(stat);
            long availableBlocks = this.getAvailableBlocksLong(stat);
            return availableBlocks * blockSize;
        }
        catch (Exception e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error getting unused internal storage amount.", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private StatFs getExternalStorageStat(@Nullable File internalStorage) {
        if (!this.isExternalStorageMounted()) {
            File path = this.getExternalStorageDep(internalStorage);
            if (path != null) {
                return new StatFs(path.getPath());
            }
            this.options.getLogger().log(SentryLevel.INFO, "Not possible to read external files directory", new Object[0]);
            return null;
        }
        this.options.getLogger().log(SentryLevel.INFO, "External storage is not mounted or emulated.", new Object[0]);
        return null;
    }

    @Nullable
    private File[] getExternalFilesDirs() {
        if (Build.VERSION.SDK_INT >= 19) {
            return this.context.getExternalFilesDirs(null);
        }
        File single = this.context.getExternalFilesDir(null);
        if (single != null) {
            return new File[]{single};
        }
        return null;
    }

    @Nullable
    private File getExternalStorageDep(@Nullable File internalStorage) {
        File[] externalFilesDirs = this.getExternalFilesDirs();
        if (externalFilesDirs != null) {
            String internalStoragePath = internalStorage != null ? internalStorage.getAbsolutePath() : null;
            for (File file : externalFilesDirs) {
                if (file == null) continue;
                if (internalStoragePath == null || internalStoragePath.isEmpty()) {
                    return file;
                }
                if (file.getAbsolutePath().contains(internalStoragePath)) continue;
                return file;
            }
        } else {
            this.options.getLogger().log(SentryLevel.INFO, "Not possible to read getExternalFilesDirs", new Object[0]);
        }
        return null;
    }

    @Nullable
    private Long getTotalExternalStorage(@NotNull StatFs stat) {
        try {
            long blockSize = this.getBlockSizeLong(stat);
            long totalBlocks = this.getBlockCountLong(stat);
            return totalBlocks * blockSize;
        }
        catch (Exception e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error getting total external storage amount.", (Throwable)e);
            return null;
        }
    }

    private boolean isExternalStorageMounted() {
        String storageState = Environment.getExternalStorageState();
        return ("mounted".equals(storageState) || "mounted_ro".equals(storageState)) && !Environment.isExternalStorageEmulated();
    }

    @Nullable
    private Long getUnusedExternalStorage(@NotNull StatFs stat) {
        try {
            long blockSize = this.getBlockSizeLong(stat);
            long availableBlocks = this.getAvailableBlocksLong(stat);
            return availableBlocks * blockSize;
        }
        catch (Exception e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error getting unused external storage amount.", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private DisplayMetrics getDisplayMetrics() {
        try {
            return this.context.getResources().getDisplayMetrics();
        }
        catch (Exception e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error getting DisplayMetrics.", (Throwable)e);
            return null;
        }
    }

    @NotNull
    private OperatingSystem getOperatingSystem() {
        OperatingSystem os = new OperatingSystem();
        os.setName("Android");
        os.setVersion(Build.VERSION.RELEASE);
        os.setBuild(Build.DISPLAY);
        try {
            Object rooted;
            Object kernelVersion = this.contextData.get().get(KERNEL_VERSION);
            if (kernelVersion != null) {
                os.setKernelVersion((String)kernelVersion);
            }
            if ((rooted = this.contextData.get().get(ROOTED)) != null) {
                os.setRooted((Boolean)rooted);
            }
        }
        catch (Exception e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error getting OperatingSystem.", (Throwable)e);
        }
        return os;
    }

    private void setAppPackageInfo(@NotNull App app, @NotNull PackageInfo packageInfo) {
        app.setAppIdentifier(packageInfo.packageName);
        app.setAppVersion(packageInfo.versionName);
        app.setAppBuild(ContextUtils.getVersionCode(packageInfo));
    }

    @Nullable
    private String getKernelVersion() {
        String string;
        String errorMsg = "Exception while attempting to read kernel information";
        String defaultVersion = System.getProperty("os.version");
        File file = new File("/proc/version");
        if (!file.canRead()) {
            return defaultVersion;
        }
        BufferedReader br = new BufferedReader(new FileReader(file));
        Throwable throwable = null;
        try {
            string = br.readLine();
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    DefaultAndroidEventProcessor.$closeResource(throwable, br);
                    throw throwable3;
                }
            }
            catch (IOException e) {
                this.options.getLogger().log(SentryLevel.ERROR, errorMsg, (Throwable)e);
                return defaultVersion;
            }
        }
        DefaultAndroidEventProcessor.$closeResource(throwable, br);
        return string;
    }

    private boolean isRooted() {
        String[] probableRootPaths;
        if (Build.TAGS != null && Build.TAGS.contains("test-keys")) {
            return true;
        }
        for (String probableRootPath : probableRootPaths = new String[]{"/data/local/bin/su", "/data/local/su", "/data/local/xbin/su", "/sbin/su", "/su/bin", "/su/bin/su", "/system/app/SuperSU", "/system/app/SuperSU.apk", "/system/app/Superuser", "/system/app/Superuser.apk", "/system/bin/failsafe/su", "/system/bin/su", "/system/sd/xbin/su", "/system/xbin/daemonsu", "/system/xbin/su"}) {
            try {
                if (!new File(probableRootPath).exists()) continue;
                return true;
            }
            catch (Exception e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Exception while attempting to detect whether the device is rooted", (Throwable)e);
            }
        }
        return false;
    }

    @Nullable
    private String getApplicationName() {
        try {
            ApplicationInfo applicationInfo = this.context.getApplicationInfo();
            int stringId = applicationInfo.labelRes;
            if (stringId == 0) {
                if (applicationInfo.nonLocalizedLabel != null) {
                    return applicationInfo.nonLocalizedLabel.toString();
                }
                return this.context.getPackageManager().getApplicationLabel(applicationInfo).toString();
            }
            return this.context.getString(stringId);
        }
        catch (Exception e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error getting application name.", (Throwable)e);
            return null;
        }
    }

    @NotNull
    public User getUser() {
        User user = new User();
        user.setId(this.getDeviceId());
        return user;
    }

    @Nullable
    private String getDeviceId() {
        try {
            Object androidId = this.contextData.get().get(ANDROID_ID);
            if (androidId != null) {
                return (String)androidId;
            }
        }
        catch (Exception e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error getting androidId.", (Throwable)e);
        }
        return null;
    }

    @Nullable
    private String getAndroidId() {
        String androidId = Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"android_id");
        if (androidId == null || androidId.isEmpty() || androidId.toLowerCase(Locale.ROOT).contentEquals("9774d56d682e549c")) {
            try {
                androidId = Installation.id(this.context);
            }
            catch (RuntimeException e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Could not generate device Id.", (Throwable)e);
                return null;
            }
        }
        return androidId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private String[] getProGuardUuids() {
        AssetManager assets = this.context.getAssets();
        try {
            String[] files = assets.list("");
            List<String> listFiles = Arrays.asList(files != null ? files : new String[]{});
            if (!listFiles.contains("sentry-debug-meta.properties")) {
                this.options.getLogger().log(SentryLevel.INFO, "Proguard UUIDs file not found.", new Object[0]);
                return null;
            }
            try (InputStream is = assets.open("sentry-debug-meta.properties");){
                Properties properties = new Properties();
                properties.load(is);
                String uuid = properties.getProperty("io.sentry.ProguardUuids");
                if (uuid != null && !uuid.isEmpty()) {
                    String[] stringArray = uuid.split("\\|", -1);
                    return stringArray;
                }
                this.options.getLogger().log(SentryLevel.INFO, "io.sentry.ProguardUuids property was not found.", new Object[0]);
            }
            catch (IOException e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Error getting Proguard UUIDs.", (Throwable)e);
            }
            this.options.getLogger().log(SentryLevel.INFO, "io.sentry.ProguardUuids property was not found.", new Object[0]);
            return null;
        }
        catch (IOException e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error listing Proguard files.", (Throwable)e);
        }
        return null;
    }
}

