/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.adapters;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import io.sentry.core.DateUtils;
import io.sentry.core.ILogger;
import io.sentry.core.SentryLevel;
import java.lang.reflect.Type;
import java.util.Date;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class DateDeserializerAdapter
implements JsonDeserializer<Date> {
    @NotNull
    private final ILogger logger;

    public DateDeserializerAdapter(@NotNull ILogger logger) {
        this.logger = logger;
    }

    public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        try {
            return json == null ? null : DateUtils.getDateTime((String)json.getAsString());
        }
        catch (Exception e) {
            this.logger.log(SentryLevel.DEBUG, "Error when deserializing UTC timestamp format, it might be mills timestamp format.", (Throwable)e);
            try {
                return DateUtils.getDateTimeWithMillsPrecision((String)json.getAsString());
            }
            catch (Exception e2) {
                this.logger.log(SentryLevel.ERROR, "Error when deserializing mills timestamp format.", (Throwable)e2);
                return null;
            }
        }
    }
}

