/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import io.sentry.android.core.EnvelopeFileObserver;
import io.sentry.core.EnvelopeReader;
import io.sentry.core.EnvelopeSender;
import io.sentry.core.IEnvelopeReader;
import io.sentry.core.IEnvelopeSender;
import io.sentry.core.IHub;
import io.sentry.core.ILogger;
import io.sentry.core.Integration;
import io.sentry.core.SentryLevel;
import io.sentry.core.SentryOptions;
import java.io.Closeable;
import org.jetbrains.annotations.Nullable;

public abstract class EnvelopeFileObserverIntegration
implements Integration,
Closeable {
    @Nullable
    private EnvelopeFileObserver observer;

    EnvelopeFileObserverIntegration() {
    }

    public static EnvelopeFileObserverIntegration getOutboxFileObserver() {
        return new OutboxEnvelopeFileObserverIntegration();
    }

    public final void register(IHub hub, SentryOptions options) {
        ILogger logger = options.getLogger();
        String path = this.getPath(options);
        if (path == null) {
            logger.log(SentryLevel.WARNING, "Null given as a path to EnvelopeFileObserverIntegration. Nothing will be registered.", new Object[0]);
        } else {
            logger.log(SentryLevel.DEBUG, "Registering EnvelopeFileObserverIntegration for path: %s", new Object[]{path});
            EnvelopeSender envelopeSender = new EnvelopeSender(hub, (IEnvelopeReader)new EnvelopeReader(), options.getSerializer(), logger);
            this.observer = new EnvelopeFileObserver(path, (IEnvelopeSender)envelopeSender, logger);
            this.observer.startWatching();
            options.getLogger().log(SentryLevel.DEBUG, "EnvelopeFileObserverIntegration installed.", new Object[0]);
        }
    }

    @Override
    public void close() {
        if (this.observer != null) {
            this.observer.stopWatching();
        }
    }

    abstract String getPath(SentryOptions var1);

    private static final class OutboxEnvelopeFileObserverIntegration
    extends EnvelopeFileObserverIntegration {
        private OutboxEnvelopeFileObserverIntegration() {
        }

        @Override
        protected String getPath(SentryOptions options) {
            return options.getOutboxPath();
        }
    }
}

