/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import io.sentry.android.core.ANRWatchDog;
import io.sentry.android.core.ApplicationNotResponding;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.core.IHub;
import io.sentry.core.ILogger;
import io.sentry.core.Integration;
import io.sentry.core.SentryLevel;
import io.sentry.core.SentryOptions;
import io.sentry.core.exception.ExceptionMechanismException;
import io.sentry.core.protocol.Mechanism;
import java.io.Closeable;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class AnrIntegration
implements Integration,
Closeable {
    private static ANRWatchDog anrWatchDog;

    public final void register(IHub hub, SentryOptions options) {
        this.register(hub, (SentryAndroidOptions)options);
    }

    private void register(IHub hub, SentryAndroidOptions options) {
        options.getLogger().log(SentryLevel.DEBUG, "AnrIntegration enabled: %s", new Object[]{options.isAnrEnabled()});
        if (options.isAnrEnabled() && anrWatchDog == null) {
            options.getLogger().log(SentryLevel.DEBUG, "ANR timeout in milliseconds: %d", new Object[]{options.getAnrTimeoutIntervalMills()});
            anrWatchDog = new ANRWatchDog(options.getAnrTimeoutIntervalMills(), options.isAnrReportInDebug(), error -> this.reportANR(hub, options.getLogger(), error), options.getLogger());
            anrWatchDog.start();
            options.getLogger().log(SentryLevel.DEBUG, "AnrIntegration installed.", new Object[0]);
        }
    }

    void reportANR(IHub hub, @NotNull ILogger logger, ApplicationNotResponding error) {
        logger.log(SentryLevel.INFO, "ANR triggered with message: %s", new Object[]{error.getMessage()});
        Mechanism mechanism = new Mechanism();
        mechanism.setType("ANR");
        ExceptionMechanismException throwable = new ExceptionMechanismException(mechanism, (Throwable)error, Thread.currentThread());
        hub.captureException((Throwable)throwable);
    }

    ANRWatchDog getANRWatchDog() {
        return anrWatchDog;
    }

    @Override
    public void close() throws IOException {
        if (anrWatchDog != null) {
            anrWatchDog.interrupt();
            anrWatchDog = null;
        }
    }
}

