/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.content.Context;
import io.sentry.android.core.AndroidLogger;
import io.sentry.android.core.AndroidSerializer;
import io.sentry.android.core.AndroidTransportGate;
import io.sentry.android.core.AnrIntegration;
import io.sentry.android.core.DefaultAndroidEventProcessor;
import io.sentry.android.core.EnvelopeFileObserverIntegration;
import io.sentry.android.core.ManifestMetadataReader;
import io.sentry.android.core.NdkIntegration;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.core.ILogger;
import io.sentry.core.SentryLevel;
import io.sentry.core.SentryOptions;
import java.io.File;
import org.jetbrains.annotations.NotNull;

final class AndroidOptionsInitializer {
    private AndroidOptionsInitializer() {
    }

    static void init(SentryAndroidOptions options, Context context) {
        AndroidOptionsInitializer.init(options, context, new AndroidLogger());
    }

    static void init(SentryAndroidOptions options, Context context, @NotNull ILogger logger) {
        options.setLogger(logger);
        options.setSentryClientName("sentry.java.android/2.0.3");
        ManifestMetadataReader.applyMetadata(context, options);
        AndroidOptionsInitializer.initializeCacheDirs(context, options);
        AndroidOptionsInitializer.setDefaultInApp(context, options);
        options.addIntegration(EnvelopeFileObserverIntegration.getOutboxFileObserver());
        options.addIntegration(new NdkIntegration());
        options.addIntegration(new AnrIntegration());
        options.addEventProcessor(new DefaultAndroidEventProcessor(context, options));
        options.setSerializer(new AndroidSerializer(options.getLogger()));
        options.setTransportGate(new AndroidTransportGate(context, options.getLogger()));
    }

    private static void setDefaultInApp(Context context, @NotNull SentryOptions options) {
        String packageName = context.getPackageName();
        if (packageName != null && !packageName.startsWith("android.")) {
            options.addInAppInclude(packageName);
        }
    }

    private static void initializeCacheDirs(Context context, SentryOptions options) {
        File cacheDir = new File(context.getCacheDir(), "sentry");
        cacheDir.mkdirs();
        options.setCacheDirPath(cacheDir.getAbsolutePath());
        if (options.getOutboxPath() != null) {
            new File(options.getOutboxPath()).mkdirs();
        } else {
            options.getLogger().log(SentryLevel.WARNING, "No outbox dir path is defined in options.", new Object[0]);
        }
    }
}

