/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.core.ILogger;
import io.sentry.core.SentryLevel;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

final class ManifestMetadataReader {
    static final String DSN = "io.sentry.dsn";
    static final String DEBUG = "io.sentry.debug";
    static final String DEBUG_LEVEL = "io.sentry.debug.level";
    static final String SAMPLE_RATE = "io.sentry.sample-rate";
    static final String ANR_ENABLE = "io.sentry.anr.enable";
    static final String ANR_REPORT_DEBUG = "io.sentry.anr.report-debug";
    static final String ANR_TIMEOUT_INTERVAL_MILLS = "io.sentry.anr.timeout-interval-mills";
    static final String AUTO_INIT = "io.sentry.auto-init";
    static final String NDK_ENABLE = "io.sentry.ndk.enable";
    static final String RELEASE = "io.sentry.release";

    private ManifestMetadataReader() {
    }

    static void applyMetadata(@NotNull Context context, @NotNull SentryAndroidOptions options) {
        if (context == null) {
            throw new IllegalArgumentException("The application context is required.");
        }
        if (options == null) {
            throw new IllegalArgumentException("The options object is required.");
        }
        try {
            Bundle metadata = ManifestMetadataReader.getMetadata(context);
            if (metadata != null) {
                boolean debug = metadata.getBoolean(DEBUG, options.isDebug());
                options.setDebug(debug);
                options.getLogger().log(SentryLevel.DEBUG, "debug read: %s", new Object[]{debug});
                if (options.isDebug()) {
                    String level = metadata.getString(DEBUG_LEVEL, options.getDiagnosticLevel().name().toLowerCase(Locale.ROOT));
                    options.setDiagnosticLevel(SentryLevel.valueOf((String)level.toUpperCase(Locale.ROOT)));
                }
                boolean anrEnabled = metadata.getBoolean(ANR_ENABLE, options.isAnrEnabled());
                options.getLogger().log(SentryLevel.DEBUG, "anrEnabled read: %s", new Object[]{anrEnabled});
                options.setAnrEnabled(anrEnabled);
                if (options.getSampleRate() == null) {
                    Double sampleRate = metadata.getDouble(SAMPLE_RATE, -1.0);
                    options.getLogger().log(SentryLevel.DEBUG, "sampleRate read: %s", new Object[]{sampleRate});
                    if (sampleRate != -1.0) {
                        options.setSampleRate(sampleRate);
                    }
                }
                boolean anrReportInDebug = metadata.getBoolean(ANR_REPORT_DEBUG, options.isAnrReportInDebug());
                options.getLogger().log(SentryLevel.DEBUG, "anrReportInDebug read: %s", new Object[]{anrReportInDebug});
                options.setAnrReportInDebug(anrReportInDebug);
                long anrTimeoutIntervalMills = metadata.getInt(ANR_TIMEOUT_INTERVAL_MILLS, (int)options.getAnrTimeoutIntervalMills());
                options.getLogger().log(SentryLevel.DEBUG, "anrTimeoutIntervalMills read: %d", new Object[]{anrTimeoutIntervalMills});
                options.setAnrTimeoutIntervalMills(anrTimeoutIntervalMills);
                String dsn = metadata.getString(DSN, null);
                if (dsn == null) {
                    options.getLogger().log(SentryLevel.FATAL, "DSN is required. Use empty string to disable SDK.", new Object[0]);
                } else if (dsn.isEmpty()) {
                    options.getLogger().log(SentryLevel.DEBUG, "DSN is empty, disabling sentry-android", new Object[0]);
                } else {
                    options.getLogger().log(SentryLevel.DEBUG, "DSN read: %s", new Object[]{dsn});
                }
                options.setDsn(dsn);
                boolean ndk = metadata.getBoolean(NDK_ENABLE, options.isEnableNdk());
                options.getLogger().log(SentryLevel.DEBUG, "NDK read: %s", new Object[]{ndk});
                options.setEnableNdk(ndk);
                String release = metadata.getString(RELEASE, options.getRelease());
                options.getLogger().log(SentryLevel.DEBUG, "release read: %s", new Object[]{release});
                options.setRelease(release);
            }
            options.getLogger().log(SentryLevel.INFO, "Retrieving configuration from AndroidManifest.xml", new Object[0]);
        }
        catch (Exception e) {
            options.getLogger().log(SentryLevel.ERROR, "Failed to read configuration from android manifest metadata.", (Throwable)e);
        }
    }

    static boolean isAutoInit(Context context, @NotNull ILogger logger) {
        if (context == null) {
            throw new IllegalArgumentException("The application context is required.");
        }
        boolean autoInit = true;
        try {
            Bundle metadata = ManifestMetadataReader.getMetadata(context);
            if (metadata != null) {
                autoInit = metadata.getBoolean(AUTO_INIT, true);
                logger.log(SentryLevel.DEBUG, "Auto-init: %s", new Object[]{autoInit});
            }
            logger.log(SentryLevel.INFO, "Retrieving auto-init from AndroidManifest.xml", new Object[0]);
        }
        catch (Exception e) {
            logger.log(SentryLevel.ERROR, "Failed to read auto-init from android manifest metadata.", (Throwable)e);
        }
        return autoInit;
    }

    private static Bundle getMetadata(Context context) throws PackageManager.NameNotFoundException {
        ApplicationInfo app = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
        return app.metaData;
    }
}

