/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.test;

import io.rsocket.Closeable;
import io.rsocket.RSocket;
import io.rsocket.core.RSocketConnector;
import io.rsocket.core.RSocketServer;
import io.rsocket.test.TestRSocket;
import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.ServerTransport;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;

public class ClientSetupRule<T, S extends Closeable> {
    private static final String data = "hello world";
    private static final String metadata = "metadata";
    private Supplier<T> addressSupplier;
    private BiFunction<T, S, RSocket> clientConnector;
    private Function<T, S> serverInit;
    private RSocket client;
    private S server;

    public ClientSetupRule(Supplier<T> addressSupplier, BiFunction<T, S, ClientTransport> clientTransportSupplier, Function<T, ServerTransport<S>> serverTransportSupplier) {
        this.addressSupplier = addressSupplier;
        this.serverInit = address -> (Closeable)RSocketServer.create((setup, rsocket) -> Mono.just((Object)new TestRSocket(data, metadata))).bind((ServerTransport)serverTransportSupplier.apply(address)).block();
        this.clientConnector = (address, server) -> (RSocket)RSocketConnector.connectWith((ClientTransport)((ClientTransport)clientTransportSupplier.apply(address, server))).doOnError(Throwable::printStackTrace).block();
    }

    public void init() {
        T address = this.addressSupplier.get();
        Closeable server = (Closeable)this.serverInit.apply(address);
        this.client = this.clientConnector.apply(address, server);
    }

    public void tearDown() {
        this.server.dispose();
    }

    public RSocket getRSocket() {
        return this.client;
    }

    public String expectedPayloadData() {
        return data;
    }

    public String expectedPayloadMetadata() {
        return metadata;
    }
}

