/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.test;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.rsocket.framing.CancelFrame;
import io.rsocket.framing.ErrorFrame;
import io.rsocket.framing.ExtensionFrame;
import io.rsocket.framing.Frame;
import io.rsocket.framing.FrameLengthFrame;
import io.rsocket.framing.FrameType;
import io.rsocket.framing.KeepaliveFrame;
import io.rsocket.framing.LeaseFrame;
import io.rsocket.framing.MetadataPushFrame;
import io.rsocket.framing.PayloadFrame;
import io.rsocket.framing.RequestChannelFrame;
import io.rsocket.framing.RequestFireAndForgetFrame;
import io.rsocket.framing.RequestNFrame;
import io.rsocket.framing.RequestResponseFrame;
import io.rsocket.framing.RequestStreamFrame;
import io.rsocket.framing.ResumeFrame;
import io.rsocket.framing.ResumeOkFrame;
import io.rsocket.framing.SetupFrame;
import io.rsocket.framing.StreamIdFrame;
import java.time.Duration;

public final class TestFrames {
    private TestFrames() {
    }

    public static CancelFrame createTestCancelFrame() {
        return CancelFrame.createCancelFrame((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
    }

    public static ErrorFrame createTestErrorFrame() {
        return ErrorFrame.createErrorFrame((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (int)1, (ByteBuf)null);
    }

    public static ExtensionFrame createTestExtensionFrame() {
        return ExtensionFrame.createExtensionFrame((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (boolean)true, (int)1, (ByteBuf)null, null);
    }

    public static Frame createTestFrame(FrameType frameType, ByteBuf byteBuf) {
        return new TestFrame(frameType, byteBuf);
    }

    public static FrameLengthFrame createTestFrameLengthFrame() {
        return FrameLengthFrame.createFrameLengthFrame((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (Frame)TestFrames.createTestStreamIdFrame());
    }

    public static KeepaliveFrame createTestKeepaliveFrame() {
        return KeepaliveFrame.createKeepaliveFrame((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (boolean)false, (long)1L, null);
    }

    public static LeaseFrame createTestLeaseFrame() {
        return LeaseFrame.createLeaseFrame((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (Duration)Duration.ofMillis(1L), (int)1, null);
    }

    public static MetadataPushFrame createTestMetadataPushFrame() {
        return MetadataPushFrame.createMetadataPushFrame((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (ByteBuf)Unpooled.EMPTY_BUFFER);
    }

    public static PayloadFrame createTestPayloadFrame() {
        return PayloadFrame.createPayloadFrame((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (boolean)false, (boolean)true, (ByteBuf)null, null);
    }

    public static RequestChannelFrame createTestRequestChannelFrame() {
        return RequestChannelFrame.createRequestChannelFrame((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (boolean)false, (boolean)false, (int)1, (ByteBuf)null, null);
    }

    public static RequestFireAndForgetFrame createTestRequestFireAndForgetFrame() {
        return RequestFireAndForgetFrame.createRequestFireAndForgetFrame((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (boolean)false, (ByteBuf)null, null);
    }

    public static RequestNFrame createTestRequestNFrame() {
        return RequestNFrame.createRequestNFrame((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (int)1);
    }

    public static RequestResponseFrame createTestRequestResponseFrame() {
        return RequestResponseFrame.createRequestResponseFrame((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (boolean)false, (ByteBuf)null, null);
    }

    public static RequestStreamFrame createTestRequestStreamFrame() {
        return RequestStreamFrame.createRequestStreamFrame((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (boolean)false, (int)1, (ByteBuf)null, null);
    }

    public static ResumeFrame createTestResumeFrame() {
        return ResumeFrame.createResumeFrame((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (int)1, (int)0, (ByteBuf)Unpooled.EMPTY_BUFFER, (long)1L, (long)1L);
    }

    public static ResumeOkFrame createTestResumeOkFrame() {
        return ResumeOkFrame.createResumeOkFrame((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (long)1L);
    }

    public static SetupFrame createTestSetupFrame() {
        return SetupFrame.createSetupFrame((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (boolean)true, (int)1, (int)1, (Duration)Duration.ofMillis(1L), (Duration)Duration.ofMillis(1L), null, (String)"", (String)"", null, null);
    }

    public static StreamIdFrame createTestStreamIdFrame() {
        return StreamIdFrame.createStreamIdFrame((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (int)1, (Frame)TestFrames.createTestCancelFrame());
    }

    private static final class TestFrame
    implements Frame {
        private final ByteBuf byteBuf;
        private final FrameType frameType;

        private TestFrame(FrameType frameType, ByteBuf byteBuf) {
            this.frameType = frameType;
            this.byteBuf = byteBuf;
        }

        public void dispose() {
        }

        public FrameType getFrameType() {
            return this.frameType;
        }

        public ByteBuf getUnsafeFrame() {
            return this.byteBuf.asReadOnly();
        }
    }
}

