/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.micrometer.observation;

import io.micrometer.observation.Observation;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.handler.TracingObservationHandler;
import io.micrometer.tracing.internal.EncodingUtils;
import io.micrometer.tracing.propagation.Propagator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.rsocket.Payload;
import io.rsocket.frame.FrameType;
import io.rsocket.metadata.RoutingMetadata;
import io.rsocket.metadata.TracingMetadata;
import io.rsocket.metadata.TracingMetadataCodec;
import io.rsocket.metadata.WellKnownMimeType;
import io.rsocket.micrometer.observation.CompositeMetadataUtils;
import io.rsocket.micrometer.observation.PayloadUtils;
import io.rsocket.micrometer.observation.RSocketContext;
import java.util.HashSet;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSocketResponderTracingObservationHandler
implements TracingObservationHandler<RSocketContext> {
    private static final Logger log = LoggerFactory.getLogger(RSocketResponderTracingObservationHandler.class);
    private final Propagator propagator;
    private final Propagator.Getter<ByteBuf> getter;
    private final Tracer tracer;
    private final boolean isZipkinPropagationEnabled;

    public RSocketResponderTracingObservationHandler(Tracer tracer, Propagator propagator, Propagator.Getter<ByteBuf> getter, boolean isZipkinPropagationEnabled) {
        this.tracer = tracer;
        this.propagator = propagator;
        this.getter = getter;
        this.isZipkinPropagationEnabled = isZipkinPropagationEnabled;
    }

    public void onStart(RSocketContext context) {
        Span handle = this.consumerSpanBuilder(context.payload, context.metadata, context.frameType);
        CompositeByteBuf bufs = PayloadUtils.cleanTracingMetadata(context.payload, new HashSet<String>(this.propagator.fields()));
        context.modifiedPayload = PayloadUtils.payload(context.payload, bufs);
        this.getTracingContext(context).setSpan(handle);
    }

    public void onError(RSocketContext context) {
        Throwable error = context.getError();
        if (error != null) {
            this.getRequiredSpan(context).error(error);
        }
    }

    public void onStop(RSocketContext context) {
        Span span = this.getRequiredSpan(context);
        this.tagSpan(context, span);
        span.end();
    }

    public boolean supportsContext(Observation.Context context) {
        return context instanceof RSocketContext && ((RSocketContext)context).side == RSocketContext.Side.RESPONDER;
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    private Span consumerSpanBuilder(Payload payload, ByteBuf headers, FrameType requestType) {
        Span.Builder consumerSpanBuilder = this.consumerSpanBuilder(payload, headers);
        log.debug("Extracted result from headers {}", (Object)consumerSpanBuilder);
        String name = "handle";
        if (payload.hasMetadata()) {
            try {
                ByteBuf extract = CompositeMetadataUtils.extract(headers, WellKnownMimeType.MESSAGE_RSOCKET_ROUTING.getString());
                if (extract != null) {
                    RoutingMetadata routingMetadata = new RoutingMetadata(extract);
                    Iterator iterator = routingMetadata.iterator();
                    name = requestType.name() + " " + (String)iterator.next();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return consumerSpanBuilder.kind(Span.Kind.CONSUMER).name(name).start();
    }

    private Span.Builder consumerSpanBuilder(Payload payload, ByteBuf headers) {
        if (this.isZipkinPropagationEnabled && payload.hasMetadata()) {
            try {
                ByteBuf extract = CompositeMetadataUtils.extract(headers, WellKnownMimeType.MESSAGE_RSOCKET_TRACING_ZIPKIN.getString());
                if (extract != null) {
                    TracingMetadata tracingMetadata = TracingMetadataCodec.decode((ByteBuf)extract);
                    Span.Builder builder = this.tracer.spanBuilder();
                    String traceId = EncodingUtils.fromLong((long)tracingMetadata.traceId());
                    long traceIdHigh = tracingMetadata.traceIdHigh();
                    if (traceIdHigh != 0L) {
                        traceId = EncodingUtils.fromLong((long)traceIdHigh) + traceId;
                    }
                    TraceContext.Builder parentBuilder = this.tracer.traceContextBuilder().sampled(Boolean.valueOf(tracingMetadata.isDebug() || tracingMetadata.isSampled())).traceId(traceId).spanId(EncodingUtils.fromLong((long)tracingMetadata.spanId())).parentId(EncodingUtils.fromLong((long)tracingMetadata.parentId()));
                    return builder.setParent(parentBuilder.build());
                }
                return this.propagator.extract((Object)headers, this.getter);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.propagator.extract((Object)headers, this.getter);
    }
}

