/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.stat;

import io.rsocket.util.Clock;
import java.util.concurrent.TimeUnit;

public class Ewma {
    private final long tau;
    private volatile long stamp;
    private volatile double ewma;

    public Ewma(long halfLife, TimeUnit unit, double initialValue) {
        this.tau = Clock.unit().convert((long)((double)halfLife / Math.log(2.0)), unit);
        this.stamp = 0L;
        this.ewma = initialValue;
    }

    public synchronized void insert(double x) {
        long now = Clock.now();
        double elapsed = Math.max(0L, now - this.stamp);
        this.stamp = now;
        double w = Math.exp(-elapsed / (double)this.tau);
        this.ewma = w * this.ewma + (1.0 - w) * x;
    }

    public synchronized void reset(double value) {
        this.stamp = 0L;
        this.ewma = value;
    }

    public double value() {
        return this.ewma;
    }

    public String toString() {
        return "Ewma(value=" + this.ewma + ", age=" + (Clock.now() - this.stamp) + ")";
    }
}

