/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.core;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.ReferenceCountUtil;
import io.rsocket.DuplexConnection;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.core.PayloadValidationUtils;
import io.rsocket.core.ReassemblyUtils;
import io.rsocket.core.RequesterResponderSupport;
import io.rsocket.core.ResponderFrameHandler;
import io.rsocket.core.SendUtils;
import io.rsocket.exceptions.CanceledException;
import io.rsocket.frame.ErrorFrameCodec;
import io.rsocket.frame.FrameType;
import io.rsocket.frame.PayloadFrameCodec;
import io.rsocket.frame.decoder.PayloadDecoder;
import io.rsocket.plugins.RequestInterceptor;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

final class RequestStreamResponderSubscriber
implements ResponderFrameHandler,
CoreSubscriber<Payload> {
    static final Logger logger = LoggerFactory.getLogger(RequestStreamResponderSubscriber.class);
    final int streamId;
    final long firstRequest;
    final ByteBufAllocator allocator;
    final PayloadDecoder payloadDecoder;
    final int mtu;
    final int maxFrameLength;
    final int maxInboundPayloadSize;
    final RequesterResponderSupport requesterResponderSupport;
    final DuplexConnection connection;
    @Nullable
    final RequestInterceptor requestInterceptor;
    final RSocket handler;
    volatile Subscription s;
    static final AtomicReferenceFieldUpdater<RequestStreamResponderSubscriber, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(RequestStreamResponderSubscriber.class, Subscription.class, "s");
    CompositeByteBuf frames;
    boolean done;

    public RequestStreamResponderSubscriber(int streamId, long firstRequest, ByteBuf firstFrame, RequesterResponderSupport requesterResponderSupport, RSocket handler) {
        this.streamId = streamId;
        this.firstRequest = firstRequest;
        this.allocator = requesterResponderSupport.getAllocator();
        this.mtu = requesterResponderSupport.getMtu();
        this.maxFrameLength = requesterResponderSupport.getMaxFrameLength();
        this.maxInboundPayloadSize = requesterResponderSupport.getMaxInboundPayloadSize();
        this.requesterResponderSupport = requesterResponderSupport;
        this.connection = requesterResponderSupport.getDuplexConnection();
        this.payloadDecoder = requesterResponderSupport.getPayloadDecoder();
        this.requestInterceptor = requesterResponderSupport.getRequestInterceptor();
        this.handler = handler;
        this.frames = ReassemblyUtils.addFollowingFrame(this.allocator.compositeBuffer(), firstFrame, true, this.maxInboundPayloadSize);
    }

    public RequestStreamResponderSubscriber(int streamId, long firstRequest, RequesterResponderSupport requesterResponderSupport) {
        this.streamId = streamId;
        this.firstRequest = firstRequest;
        this.allocator = requesterResponderSupport.getAllocator();
        this.mtu = requesterResponderSupport.getMtu();
        this.maxFrameLength = requesterResponderSupport.getMaxFrameLength();
        this.maxInboundPayloadSize = requesterResponderSupport.getMaxInboundPayloadSize();
        this.requesterResponderSupport = requesterResponderSupport;
        this.connection = requesterResponderSupport.getDuplexConnection();
        this.requestInterceptor = requesterResponderSupport.getRequestInterceptor();
        this.payloadDecoder = null;
        this.handler = null;
        this.frames = null;
    }

    public void onSubscribe(Subscription subscription) {
        if (Operators.validate((Subscription)this.s, (Subscription)subscription)) {
            long firstRequest = this.firstRequest;
            S.lazySet(this, subscription);
            subscription.request(firstRequest);
        }
    }

    public void onNext(Payload p) {
        block11: {
            if (this.done) {
                ReferenceCountUtil.safeRelease((Object)p);
                return;
            }
            int streamId = this.streamId;
            DuplexConnection sender = this.connection;
            ByteBufAllocator allocator = this.allocator;
            int mtu = this.mtu;
            try {
                if (!PayloadValidationUtils.isValid(mtu, this.maxFrameLength, p, false)) {
                    p.release();
                    if (!this.tryTerminateOnError()) {
                        return;
                    }
                    CanceledException e = new CanceledException(String.format("The payload is too big to be send as a single frame with a max frame length %s. Consider enabling fragmentation.", this.maxFrameLength));
                    ByteBuf errorFrame = ErrorFrameCodec.encode(allocator, streamId, e);
                    sender.sendFrame(streamId, errorFrame);
                    RequestInterceptor requestInterceptor = this.requestInterceptor;
                    if (requestInterceptor != null) {
                        requestInterceptor.onTerminate(streamId, FrameType.REQUEST_STREAM, e);
                    }
                    return;
                }
            }
            catch (IllegalReferenceCountException e) {
                if (!this.tryTerminateOnError()) {
                    return;
                }
                ByteBuf errorFrame = ErrorFrameCodec.encode(allocator, streamId, new CanceledException("Failed to validate payload. Cause" + e.getMessage()));
                sender.sendFrame(streamId, errorFrame);
                RequestInterceptor requestInterceptor = this.requestInterceptor;
                if (requestInterceptor != null) {
                    requestInterceptor.onTerminate(streamId, FrameType.REQUEST_STREAM, e);
                }
                return;
            }
            try {
                SendUtils.sendReleasingPayload(streamId, FrameType.NEXT, mtu, p, sender, allocator, false);
            }
            catch (Throwable t) {
                if (!this.tryTerminateOnError()) {
                    return;
                }
                RequestInterceptor requestInterceptor = this.requestInterceptor;
                if (requestInterceptor == null) break block11;
                requestInterceptor.onTerminate(streamId, FrameType.REQUEST_STREAM, t);
            }
        }
    }

    boolean tryTerminateOnError() {
        Subscription currentSubscription = this.s;
        if (currentSubscription == Operators.cancelledSubscription()) {
            return false;
        }
        this.done = true;
        if (!S.compareAndSet(this, currentSubscription, Operators.cancelledSubscription())) {
            return false;
        }
        this.requesterResponderSupport.remove(this.streamId, this);
        currentSubscription.cancel();
        return true;
    }

    public void onError(Throwable t) {
        if (this.done) {
            logger.debug("Dropped error", t);
            return;
        }
        this.done = true;
        if (S.getAndSet(this, Operators.cancelledSubscription()) == Operators.cancelledSubscription()) {
            logger.debug("Dropped error", t);
            return;
        }
        CompositeByteBuf frames = this.frames;
        if (frames != null && frames.refCnt() > 0) {
            frames.release();
        }
        int streamId = this.streamId;
        this.requesterResponderSupport.remove(streamId, this);
        ByteBuf errorFrame = ErrorFrameCodec.encode(this.allocator, streamId, t);
        this.connection.sendFrame(streamId, errorFrame);
        RequestInterceptor requestInterceptor = this.requestInterceptor;
        if (requestInterceptor != null) {
            requestInterceptor.onTerminate(streamId, FrameType.REQUEST_STREAM, t);
        }
    }

    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        if (S.getAndSet(this, Operators.cancelledSubscription()) == Operators.cancelledSubscription()) {
            return;
        }
        int streamId = this.streamId;
        this.requesterResponderSupport.remove(streamId, this);
        ByteBuf completeFrame = PayloadFrameCodec.encodeComplete(this.allocator, streamId);
        this.connection.sendFrame(streamId, completeFrame);
        RequestInterceptor requestInterceptor = this.requestInterceptor;
        if (requestInterceptor != null) {
            requestInterceptor.onTerminate(streamId, FrameType.REQUEST_STREAM, null);
        }
    }

    @Override
    public void handleRequestN(long n) {
        this.s.request(n);
    }

    @Override
    public final void handleCancel() {
        Subscription currentSubscription = this.s;
        if (currentSubscription == Operators.cancelledSubscription()) {
            return;
        }
        if (currentSubscription == null) {
            RequestInterceptor requestInterceptor;
            S.lazySet(this, Operators.cancelledSubscription());
            int streamId = this.streamId;
            this.requesterResponderSupport.remove(streamId, this);
            CompositeByteBuf frames = this.frames;
            if (frames != null) {
                this.frames = null;
                frames.release();
            }
            if ((requestInterceptor = this.requestInterceptor) != null) {
                requestInterceptor.onCancel(streamId, FrameType.REQUEST_STREAM);
            }
            return;
        }
        if (!S.compareAndSet(this, currentSubscription, Operators.cancelledSubscription())) {
            return;
        }
        int streamId = this.streamId;
        this.requesterResponderSupport.remove(streamId, this);
        currentSubscription.cancel();
        RequestInterceptor requestInterceptor = this.requestInterceptor;
        if (requestInterceptor != null) {
            requestInterceptor.onCancel(streamId, FrameType.REQUEST_STREAM);
        }
    }

    @Override
    public void handleNext(ByteBuf followingFrame, boolean hasFollows, boolean isLastPayload) {
        CompositeByteBuf frames = this.frames;
        if (frames == null) {
            return;
        }
        try {
            ReassemblyUtils.addFollowingFrame(frames, followingFrame, hasFollows, this.maxInboundPayloadSize);
        }
        catch (IllegalStateException e) {
            S.lazySet(this, Operators.cancelledSubscription());
            int streamId = this.streamId;
            this.requesterResponderSupport.remove(streamId, this);
            this.frames = null;
            frames.release();
            ByteBuf errorFrame = ErrorFrameCodec.encode(this.allocator, streamId, new CanceledException("Failed to reassemble payload. Cause: " + e.getMessage()));
            this.connection.sendFrame(streamId, errorFrame);
            RequestInterceptor requestInterceptor = this.requestInterceptor;
            if (requestInterceptor != null) {
                requestInterceptor.onTerminate(streamId, FrameType.REQUEST_STREAM, e);
            }
            logger.debug("Reassembly has failed", (Throwable)e);
            return;
        }
        if (!hasFollows) {
            Payload payload;
            this.frames = null;
            try {
                payload = (Payload)this.payloadDecoder.apply(frames);
                frames.release();
            }
            catch (Throwable t) {
                S.lazySet(this, Operators.cancelledSubscription());
                this.done = true;
                int streamId = this.streamId;
                this.requesterResponderSupport.remove(streamId, this);
                ReferenceCountUtil.safeRelease((Object)frames);
                ByteBuf errorFrame = ErrorFrameCodec.encode(this.allocator, streamId, new CanceledException("Failed to reassemble payload. Cause: " + t.getMessage()));
                this.connection.sendFrame(streamId, errorFrame);
                RequestInterceptor requestInterceptor = this.requestInterceptor;
                if (requestInterceptor != null) {
                    requestInterceptor.onTerminate(streamId, FrameType.REQUEST_STREAM, t);
                }
                logger.debug("Reassembly has failed", t);
                return;
            }
            Flux<Payload> source = this.handler.requestStream(payload);
            source.subscribe((CoreSubscriber)this);
        }
    }

    public Context currentContext() {
        return SendUtils.DISCARD_CONTEXT;
    }
}

