/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.core;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.util.IllegalReferenceCountException;
import io.rsocket.DuplexConnection;
import io.rsocket.Payload;
import io.rsocket.core.PayloadValidationUtils;
import io.rsocket.core.ReassemblyUtils;
import io.rsocket.core.RequesterFrameHandler;
import io.rsocket.core.RequesterResponderSupport;
import io.rsocket.core.SendUtils;
import io.rsocket.core.StateUtils;
import io.rsocket.frame.CancelFrameCodec;
import io.rsocket.frame.FrameType;
import io.rsocket.frame.decoder.PayloadDecoder;
import io.rsocket.plugins.RequestInterceptor;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.util.annotation.NonNull;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

final class RequestResponseRequesterMono
extends Mono<Payload>
implements RequesterFrameHandler,
Subscription,
Scannable {
    final ByteBufAllocator allocator;
    final Payload payload;
    final int mtu;
    final int maxFrameLength;
    final int maxInboundPayloadSize;
    final RequesterResponderSupport requesterResponderSupport;
    final DuplexConnection connection;
    final PayloadDecoder payloadDecoder;
    @Nullable
    final RequestInterceptor requestInterceptor;
    volatile long state;
    static final AtomicLongFieldUpdater<RequestResponseRequesterMono> STATE = AtomicLongFieldUpdater.newUpdater(RequestResponseRequesterMono.class, "state");
    int streamId;
    CoreSubscriber<? super Payload> actual;
    CompositeByteBuf frames;
    boolean done;

    RequestResponseRequesterMono(Payload payload, RequesterResponderSupport requesterResponderSupport) {
        this.allocator = requesterResponderSupport.getAllocator();
        this.payload = payload;
        this.mtu = requesterResponderSupport.getMtu();
        this.maxFrameLength = requesterResponderSupport.getMaxFrameLength();
        this.maxInboundPayloadSize = requesterResponderSupport.getMaxInboundPayloadSize();
        this.requesterResponderSupport = requesterResponderSupport;
        this.connection = requesterResponderSupport.getDuplexConnection();
        this.payloadDecoder = requesterResponderSupport.getPayloadDecoder();
        this.requestInterceptor = requesterResponderSupport.getRequestInterceptor();
    }

    public void subscribe(CoreSubscriber<? super Payload> actual) {
        long previousState = StateUtils.markSubscribed(STATE, this);
        if (StateUtils.isSubscribedOrTerminated(previousState)) {
            IllegalStateException e = new IllegalStateException("RequestResponseMono allows only a single Subscriber");
            RequestInterceptor requestInterceptor = this.requestInterceptor;
            if (requestInterceptor != null) {
                requestInterceptor.onReject(e, FrameType.REQUEST_RESPONSE, null);
            }
            Operators.error(actual, (Throwable)e);
            return;
        }
        Payload p = this.payload;
        try {
            if (!PayloadValidationUtils.isValid(this.mtu, this.maxFrameLength, p, false)) {
                StateUtils.lazyTerminate(STATE, this);
                IllegalArgumentException e = new IllegalArgumentException(String.format("The payload is too big to be send as a single frame with a max frame length %s. Consider enabling fragmentation.", this.maxFrameLength));
                RequestInterceptor requestInterceptor = this.requestInterceptor;
                if (requestInterceptor != null) {
                    requestInterceptor.onReject(e, FrameType.REQUEST_RESPONSE, p.metadata());
                }
                p.release();
                Operators.error(actual, (Throwable)e);
                return;
            }
        }
        catch (IllegalReferenceCountException e) {
            StateUtils.lazyTerminate(STATE, this);
            RequestInterceptor requestInterceptor = this.requestInterceptor;
            if (requestInterceptor != null) {
                requestInterceptor.onReject(e, FrameType.REQUEST_RESPONSE, null);
            }
            Operators.error(actual, (Throwable)e);
            return;
        }
        this.actual = actual;
        actual.onSubscribe((Subscription)this);
    }

    public final void request(long n) {
        if (!Operators.validate((long)n)) {
            return;
        }
        long previousState = StateUtils.addRequestN(STATE, this, n);
        if (StateUtils.isTerminated(previousState) || StateUtils.hasRequested(previousState)) {
            return;
        }
        this.sendFirstPayload(this.payload, n);
    }

    void sendFirstPayload(Payload payload, long initialRequestN) {
        int streamId;
        RequesterResponderSupport sm = this.requesterResponderSupport;
        DuplexConnection connection = this.connection;
        ByteBufAllocator allocator = this.allocator;
        try {
            this.streamId = streamId = sm.addAndGetNextStreamId(this);
        }
        catch (Throwable t) {
            this.done = true;
            long previousState = StateUtils.markTerminated(STATE, this);
            Throwable ut = Exceptions.unwrap((Throwable)t);
            RequestInterceptor requestInterceptor = this.requestInterceptor;
            if (requestInterceptor != null) {
                requestInterceptor.onReject(ut, FrameType.REQUEST_RESPONSE, payload.metadata());
            }
            payload.release();
            if (!StateUtils.isTerminated(previousState)) {
                this.actual.onError(ut);
            }
            return;
        }
        RequestInterceptor requestInterceptor = this.requestInterceptor;
        if (requestInterceptor != null) {
            requestInterceptor.onStart(streamId, FrameType.REQUEST_RESPONSE, payload.metadata());
        }
        try {
            SendUtils.sendReleasingPayload(streamId, FrameType.REQUEST_RESPONSE, this.mtu, payload, connection, allocator, true);
        }
        catch (Throwable e) {
            this.done = true;
            StateUtils.lazyTerminate(STATE, this);
            sm.remove(streamId, this);
            if (requestInterceptor != null) {
                requestInterceptor.onTerminate(streamId, FrameType.REQUEST_RESPONSE, e);
            }
            this.actual.onError(e);
            return;
        }
        long previousState = StateUtils.markFirstFrameSent(STATE, this);
        if (StateUtils.isTerminated(previousState)) {
            if (this.done) {
                return;
            }
            sm.remove(streamId, this);
            ByteBuf cancelFrame = CancelFrameCodec.encode(allocator, streamId);
            connection.sendFrame(streamId, cancelFrame);
            if (requestInterceptor != null) {
                requestInterceptor.onCancel(streamId, FrameType.REQUEST_RESPONSE);
            }
        }
    }

    public final void cancel() {
        long previousState = StateUtils.markTerminated(STATE, this);
        if (StateUtils.isTerminated(previousState)) {
            return;
        }
        if (StateUtils.isFirstFrameSent(previousState)) {
            int streamId = this.streamId;
            this.requesterResponderSupport.remove(streamId, this);
            ReassemblyUtils.synchronizedRelease(this, previousState);
            this.connection.sendFrame(streamId, CancelFrameCodec.encode(this.allocator, streamId));
            RequestInterceptor requestInterceptor = this.requestInterceptor;
            if (requestInterceptor != null) {
                requestInterceptor.onCancel(streamId, FrameType.REQUEST_RESPONSE);
            }
        } else if (!StateUtils.hasRequested(previousState)) {
            this.payload.release();
        }
    }

    @Override
    public final void handlePayload(Payload value) {
        if (this.done) {
            value.release();
            return;
        }
        this.done = true;
        long previousState = StateUtils.markTerminated(STATE, this);
        if (StateUtils.isTerminated(previousState)) {
            value.release();
            return;
        }
        int streamId = this.streamId;
        this.requesterResponderSupport.remove(streamId, this);
        RequestInterceptor requestInterceptor = this.requestInterceptor;
        if (requestInterceptor != null) {
            requestInterceptor.onTerminate(streamId, FrameType.REQUEST_RESPONSE, null);
        }
        CoreSubscriber<? super Payload> a = this.actual;
        a.onNext((Object)value);
        a.onComplete();
    }

    @Override
    public final void handleComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        long previousState = StateUtils.markTerminated(STATE, this);
        if (StateUtils.isTerminated(previousState)) {
            return;
        }
        int streamId = this.streamId;
        this.requesterResponderSupport.remove(streamId, this);
        RequestInterceptor requestInterceptor = this.requestInterceptor;
        if (requestInterceptor != null) {
            requestInterceptor.onTerminate(streamId, FrameType.REQUEST_RESPONSE, null);
        }
        this.actual.onComplete();
    }

    @Override
    public final void handleError(Throwable cause) {
        if (this.done) {
            Operators.onErrorDropped((Throwable)cause, (Context)this.actual.currentContext());
            return;
        }
        this.done = true;
        long previousState = StateUtils.markTerminated(STATE, this);
        if (StateUtils.isTerminated(previousState)) {
            Operators.onErrorDropped((Throwable)cause, (Context)this.actual.currentContext());
            return;
        }
        ReassemblyUtils.synchronizedRelease(this, previousState);
        int streamId = this.streamId;
        this.requesterResponderSupport.remove(streamId, this);
        RequestInterceptor requestInterceptor = this.requestInterceptor;
        if (requestInterceptor != null) {
            requestInterceptor.onTerminate(streamId, FrameType.REQUEST_RESPONSE, cause);
        }
        this.actual.onError(cause);
    }

    @Override
    public void handleNext(ByteBuf frame, boolean hasFollows, boolean isLastPayload) {
        ReassemblyUtils.handleNextSupport(STATE, this, this, this.actual, this.payloadDecoder, this.allocator, this.maxInboundPayloadSize, frame, hasFollows, isLastPayload);
    }

    @Override
    public CompositeByteBuf getFrames() {
        return this.frames;
    }

    @Override
    public void setFrames(CompositeByteBuf byteBuf) {
        this.frames = byteBuf;
    }

    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        long state = this.state;
        if (key == Scannable.Attr.TERMINATED) {
            return StateUtils.isTerminated(state);
        }
        if (key == Scannable.Attr.PREFETCH) {
            return 0;
        }
        return null;
    }

    @NonNull
    public String stepName() {
        return "source(RequestResponseMono)";
    }
}

