/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.loadbalance;

import io.rsocket.loadbalance.FrugalQuantile;

class Median
extends FrugalQuantile {
    public Median() {
        super(0.5, 1.0);
    }

    public synchronized void reset() {
        super.reset(0.5);
    }

    @Override
    public synchronized void insert(double x) {
        if (this.sign == 0) {
            this.estimate = x;
            this.sign = 1;
        } else if (x > this.estimate) {
            this.greaterThanZero(x);
        } else if (x < this.estimate) {
            this.lessThanZero(x);
        }
    }

    private void greaterThanZero(double x) {
        this.step += this.sign;
        this.estimate = this.step > 0 ? (this.estimate += (double)this.step) : (this.estimate += 1.0);
        if (this.estimate > x) {
            this.step = (int)((double)this.step + (x - this.estimate));
            this.estimate = x;
        }
        if (this.sign < 0) {
            this.step = 1;
        }
        this.sign = 1;
    }

    private void lessThanZero(double x) {
        this.step -= this.sign;
        this.estimate = this.step > 0 ? (this.estimate -= (double)this.step) : (this.estimate -= 1.0);
        if (this.estimate < x) {
            this.step = (int)((double)this.step + (this.estimate - x));
            this.estimate = x;
        }
        if (this.sign > 0) {
            this.step = 1;
        }
        this.sign = -1;
    }

    @Override
    public String toString() {
        return "Median(v=" + this.estimate + ")";
    }
}

