/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.core;

import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

class ResolvingOperator<T>
implements Disposable {
    static final CancellationException ON_DISPOSE = new CancellationException("Disposed");
    volatile int wip;
    static final AtomicIntegerFieldUpdater<ResolvingOperator> WIP = AtomicIntegerFieldUpdater.newUpdater(ResolvingOperator.class, "wip");
    volatile BiConsumer<T, Throwable>[] subscribers;
    static final AtomicReferenceFieldUpdater<ResolvingOperator, BiConsumer[]> SUBSCRIBERS = AtomicReferenceFieldUpdater.newUpdater(ResolvingOperator.class, BiConsumer[].class, "subscribers");
    static final BiConsumer<?, Throwable>[] EMPTY_UNSUBSCRIBED = new BiConsumer[0];
    static final BiConsumer<?, Throwable>[] EMPTY_SUBSCRIBED = new BiConsumer[0];
    static final BiConsumer<?, Throwable>[] READY = new BiConsumer[0];
    static final BiConsumer<?, Throwable>[] TERMINATED = new BiConsumer[0];
    static final int ADDED_STATE = 0;
    static final int READY_STATE = 1;
    static final int TERMINATED_STATE = 2;
    T value;
    Throwable t;

    public ResolvingOperator() {
        SUBSCRIBERS.lazySet(this, EMPTY_UNSUBSCRIBED);
    }

    public final void dispose() {
        this.terminate(ON_DISPOSE);
    }

    public final boolean isDisposed() {
        return this.subscribers == TERMINATED;
    }

    public final boolean isPending() {
        BiConsumer<T, Throwable>[] state = this.subscribers;
        return state != READY && state != TERMINATED;
    }

    @Nullable
    public final T valueIfResolved() {
        T value;
        if (this.subscribers == READY && (value = this.value) != null) {
            return value;
        }
        return null;
    }

    final void observe(BiConsumer<T, Throwable> actual) {
        int state;
        block2: {
            T value;
            do {
                state = this.add(actual);
                value = this.value;
                if (state != 1) break block2;
            } while (value == null);
            actual.accept(value, null);
            return;
        }
        if (state == 2) {
            actual.accept(null, this.t);
            return;
        }
    }

    @Nullable
    public T block(@Nullable Duration timeout) {
        try {
            BiConsumer<T, Throwable>[] subscribers = this.subscribers;
            if (subscribers == READY) {
                T value = this.value;
                if (value != null) {
                    return value;
                }
                subscribers = this.subscribers;
            }
            if (subscribers == TERMINATED) {
                RuntimeException re = Exceptions.propagate((Throwable)this.t);
                re = Exceptions.addSuppressed((RuntimeException)re, (Throwable)new Exception("Terminated with an error"));
                throw re;
            }
            if (subscribers == EMPTY_UNSUBSCRIBED && SUBSCRIBERS.compareAndSet(this, EMPTY_UNSUBSCRIBED, EMPTY_SUBSCRIBED)) {
                this.doSubscribe();
            }
            long delay = null == timeout ? 0L : System.nanoTime() + timeout.toNanos();
            while (true) {
                BiConsumer<T, Throwable>[] inners;
                if ((inners = this.subscribers) == READY) {
                    T value = this.value;
                    if (value != null) {
                        return value;
                    }
                    inners = this.subscribers;
                }
                if (inners == TERMINATED) {
                    RuntimeException re = Exceptions.propagate((Throwable)this.t);
                    re = Exceptions.addSuppressed((RuntimeException)re, (Throwable)new Exception("Terminated with an error"));
                    throw re;
                }
                if (timeout != null && delay < System.nanoTime()) {
                    throw new IllegalStateException("Timeout on Mono blocking read");
                }
                Thread.sleep(1L);
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Thread Interruption on Mono blocking read");
        }
    }

    final void terminate(Throwable t) {
        if (this.isDisposed()) {
            return;
        }
        this.t = t;
        BiConsumer<?, Throwable>[] subscribers = SUBSCRIBERS.getAndSet(this, TERMINATED);
        if (subscribers == TERMINATED) {
            Operators.onErrorDropped((Throwable)t, (Context)Context.empty());
            return;
        }
        this.doOnDispose();
        this.doFinally();
        for (BiConsumer<?, Throwable> consumer : subscribers) {
            consumer.accept(null, t);
        }
    }

    final void complete(T value) {
        BiConsumer<T, Throwable>[] subscribers = this.subscribers;
        if (subscribers == TERMINATED) {
            this.doOnValueExpired(value);
            return;
        }
        this.value = value;
        while (!SUBSCRIBERS.compareAndSet(this, subscribers, READY)) {
            subscribers = this.subscribers;
            if (subscribers != TERMINATED) continue;
            this.doFinally();
            return;
        }
        this.doOnValueResolved(value);
        for (BiConsumer<T, Throwable> consumer : subscribers) {
            consumer.accept(value, null);
        }
    }

    protected void doOnValueResolved(T value) {
    }

    final void doFinally() {
        if (WIP.getAndIncrement(this) != 0) {
            return;
        }
        int m = 1;
        do {
            T value;
            if ((value = this.value) == null || !this.isDisposed()) continue;
            this.value = null;
            this.doOnValueExpired(value);
            return;
        } while ((m = WIP.addAndGet(this, -m)) != 0);
    }

    final void invalidate() {
        if (this.subscribers == TERMINATED) {
            return;
        }
        BiConsumer<T, Throwable>[] subscribers = this.subscribers;
        if (subscribers == READY) {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            T value = this.value;
            if (value != null) {
                this.value = null;
                this.doOnValueExpired(value);
            }
            int m = 1;
            do {
                if (!this.isDisposed()) continue;
                return;
            } while ((m = WIP.addAndGet(this, -m)) != 0);
            SUBSCRIBERS.compareAndSet(this, READY, EMPTY_UNSUBSCRIBED);
        }
    }

    protected void doOnValueExpired(T value) {
    }

    protected void doOnDispose() {
    }

    final int add(BiConsumer<T, Throwable> ps) {
        BiConsumer[] b;
        BiConsumer<T, Throwable>[] a;
        do {
            if ((a = this.subscribers) == TERMINATED) {
                return 2;
            }
            if (a == READY) {
                return 1;
            }
            int n = a.length;
            b = new BiConsumer[n + 1];
            System.arraycopy(a, 0, b, 0, n);
            b[n] = ps;
        } while (!SUBSCRIBERS.compareAndSet(this, a, b));
        if (a == EMPTY_UNSUBSCRIBED) {
            this.doSubscribe();
        }
        return 0;
    }

    protected void doSubscribe() {
    }

    final void remove(BiConsumer<T, Throwable> ps) {
        BiConsumer<?, Throwable>[] b;
        BiConsumer<T, Throwable>[] a;
        do {
            int n;
            if ((n = (a = this.subscribers).length) == 0) {
                return;
            }
            int j = -1;
            for (int i = 0; i < n; ++i) {
                if (a[i] != ps) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (n == 1) {
                b = EMPTY_SUBSCRIBED;
                continue;
            }
            b = new BiConsumer[n - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, n - j - 1);
        } while (!SUBSCRIBERS.compareAndSet(this, a, b));
    }

    static class MonoDeferredResolutionOperator<T>
    extends Operators.MonoSubscriber<T, T>
    implements BiConsumer<T, Throwable> {
        final ResolvingOperator<T> parent;

        MonoDeferredResolutionOperator(ResolvingOperator<T> parent, CoreSubscriber<? super T> actual) {
            super(actual);
            this.parent = parent;
        }

        @Override
        public void accept(T t, Throwable throwable) {
            if (throwable != null) {
                this.onError(throwable);
                return;
            }
            this.complete(t);
        }

        public void cancel() {
            if (!this.isCancelled()) {
                super.cancel();
                this.parent.remove(this);
            }
        }

        public void onComplete() {
            if (!this.isCancelled()) {
                this.actual.onComplete();
            }
        }

        public void onError(Throwable t) {
            if (this.isCancelled()) {
                Operators.onErrorDropped((Throwable)t, (Context)this.currentContext());
            } else {
                this.actual.onError(t);
            }
        }

        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.parent;
            }
            return super.scanUnsafe(key);
        }
    }

    static abstract class DeferredResolution<T, R>
    implements CoreSubscriber<T>,
    Subscription,
    Scannable,
    BiConsumer<R, Throwable> {
        final ResolvingOperator<R> parent;
        final CoreSubscriber<? super T> actual;
        volatile long requested;
        static final AtomicLongFieldUpdater<DeferredResolution> REQUESTED = AtomicLongFieldUpdater.newUpdater(DeferredResolution.class, "requested");
        static final long STATE_SUBSCRIBED = -1L;
        static final long STATE_CANCELLED = Long.MIN_VALUE;
        Subscription s;
        boolean done;

        DeferredResolution(ResolvingOperator<R> parent, CoreSubscriber<? super T> actual) {
            this.parent = parent;
            this.actual = actual;
        }

        public final Context currentContext() {
            return this.actual.currentContext();
        }

        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            long state = this.requested;
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.ACTUAL) {
                return this.parent;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            if (key == Scannable.Attr.CANCELLED) {
                return state == Long.MIN_VALUE;
            }
            return null;
        }

        public final void onSubscribe(Subscription s) {
            long r;
            long state = this.requested;
            Subscription a = this.s;
            if (state == Long.MIN_VALUE) {
                s.cancel();
                return;
            }
            if (a != null) {
                s.cancel();
                return;
            }
            long accumulated = 0L;
            do {
                if ((r = this.requested) == Long.MIN_VALUE || r == -1L) {
                    s.cancel();
                    return;
                }
                this.s = s;
                long toRequest = r - accumulated;
                if (toRequest > 0L) {
                    s.request(toRequest);
                }
                accumulated = r;
            } while (!REQUESTED.compareAndSet(this, r, -1L));
        }

        public final void onNext(T payload) {
            this.actual.onNext(payload);
        }

        public final void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped((Throwable)t, (Context)this.actual.currentContext());
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public final void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        public void request(long n) {
            if (Operators.validate((long)n)) {
                long r = this.requested;
                if (r > -1L) {
                    do {
                        if (r == Long.MAX_VALUE) {
                            return;
                        }
                        long u = Operators.addCap((long)r, (long)n);
                        if (!REQUESTED.compareAndSet(this, r, u)) continue;
                        return;
                    } while ((r = this.requested) >= 0L);
                }
                if (r == Long.MIN_VALUE) {
                    return;
                }
                this.s.request(n);
            }
        }

        public boolean isCancelled() {
            return this.requested == Long.MIN_VALUE;
        }

        public void cancel() {
            long state = REQUESTED.getAndSet(this, Long.MIN_VALUE);
            if (state == Long.MIN_VALUE) {
                return;
            }
            if (state == -1L) {
                this.s.cancel();
            } else {
                this.parent.remove(this);
            }
        }
    }
}

