/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket;

import io.rsocket.Payload;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class RSocketAdapter {
    private static final Mono<Void> UNSUPPORTED_FIRE_AND_FORGET = Mono.error((Throwable)new UnsupportedInteractionException("Fire-and-Forget"));
    private static final Mono<Payload> UNSUPPORTED_REQUEST_RESPONSE = Mono.error((Throwable)new UnsupportedInteractionException("Request-Response"));
    private static final Flux<Payload> UNSUPPORTED_REQUEST_STREAM = Flux.error((Throwable)new UnsupportedInteractionException("Request-Stream"));
    private static final Flux<Payload> UNSUPPORTED_REQUEST_CHANNEL = Flux.error((Throwable)new UnsupportedInteractionException("Request-Channel"));
    private static final Mono<Void> UNSUPPORTED_METADATA_PUSH = Mono.error((Throwable)new UnsupportedInteractionException("Metadata-Push"));

    RSocketAdapter() {
    }

    static Mono<Void> fireAndForget(Payload payload) {
        payload.release();
        return UNSUPPORTED_FIRE_AND_FORGET;
    }

    static Mono<Payload> requestResponse(Payload payload) {
        payload.release();
        return UNSUPPORTED_REQUEST_RESPONSE;
    }

    static Flux<Payload> requestStream(Payload payload) {
        payload.release();
        return UNSUPPORTED_REQUEST_STREAM;
    }

    static Flux<Payload> requestChannel(Publisher<Payload> payloads) {
        return UNSUPPORTED_REQUEST_CHANNEL;
    }

    static Mono<Void> metadataPush(Payload payload) {
        payload.release();
        return UNSUPPORTED_METADATA_PUSH;
    }

    private static class UnsupportedInteractionException
    extends RuntimeException {
        private static final long serialVersionUID = 5084623297446471999L;

        UnsupportedInteractionException(String interactionName) {
            super(interactionName + " not implemented.", null, false, false);
        }
    }
}

