/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.loadbalance.stat;

import io.rsocket.loadbalance.stat.Quantile;
import java.util.SplittableRandom;

public class FrugalQuantile
implements Quantile {
    private final double increment;
    volatile double estimate;
    int step;
    int sign;
    private double quantile;
    private SplittableRandom rnd;

    public FrugalQuantile(double quantile, double increment) {
        this.increment = increment;
        this.quantile = quantile;
        this.estimate = 0.0;
        this.step = 1;
        this.sign = 0;
        this.rnd = new SplittableRandom(System.nanoTime());
    }

    public FrugalQuantile(double quantile) {
        this(quantile, 1.0);
    }

    public synchronized void reset(double quantile) {
        this.quantile = quantile;
        this.estimate = 0.0;
        this.step = 1;
        this.sign = 0;
    }

    @Override
    public double estimation() {
        return this.estimate;
    }

    @Override
    public synchronized void insert(double x) {
        if (this.sign == 0) {
            this.estimate = x;
            this.sign = 1;
        } else {
            double v = this.rnd.nextDouble();
            if (x > this.estimate && v > 1.0 - this.quantile) {
                this.higher(x);
            } else if (x < this.estimate && v > this.quantile) {
                this.lower(x);
            }
        }
    }

    private void higher(double x) {
        this.step = (int)((double)this.step + (double)this.sign * this.increment);
        this.estimate = this.step > 0 ? (this.estimate += (double)this.step) : (this.estimate += 1.0);
        if (this.estimate > x) {
            this.step = (int)((double)this.step + (x - this.estimate));
            this.estimate = x;
        }
        if (this.sign < 0) {
            this.step = 1;
        }
        this.sign = 1;
    }

    private void lower(double x) {
        this.step = (int)((double)this.step - (double)this.sign * this.increment);
        this.estimate = this.step > 0 ? (this.estimate -= (double)this.step) : (this.estimate -= 1.0);
        if (this.estimate < x) {
            this.step = (int)((double)this.step + (this.estimate - x));
            this.estimate = x;
        }
        if (this.sign > 0) {
            this.step = 1;
        }
        this.sign = -1;
    }

    public String toString() {
        return "FrugalQuantile(q=" + this.quantile + ", v=" + this.estimate + ")";
    }
}

