/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.loadbalance;

import io.rsocket.loadbalance.LoadbalanceStrategy;
import io.rsocket.loadbalance.PooledRSocket;
import io.rsocket.loadbalance.Stats;
import java.util.SplittableRandom;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import reactor.util.annotation.Nullable;

public class WeightedLoadbalanceStrategy
implements LoadbalanceStrategy {
    private static final double EXP_FACTOR = 4.0;
    private static final int EFFORT = 5;
    final SplittableRandom splittableRandom;
    final int effort;
    final Supplier<Stats> statsSupplier;

    public WeightedLoadbalanceStrategy() {
        this(5);
    }

    public WeightedLoadbalanceStrategy(int effort) {
        this(effort, new SplittableRandom(System.nanoTime()));
    }

    public WeightedLoadbalanceStrategy(int effort, SplittableRandom splittableRandom) {
        this(effort, splittableRandom, Stats::create);
    }

    public WeightedLoadbalanceStrategy(int effort, SplittableRandom splittableRandom, Supplier<Stats> statsSupplier) {
        this.splittableRandom = splittableRandom;
        this.effort = effort;
        this.statsSupplier = statsSupplier;
    }

    @Override
    public Supplier<Stats> statsSupplier() {
        return this.statsSupplier;
    }

    @Override
    public PooledRSocket select(PooledRSocket[] sockets) {
        PooledRSocket pooledRSocket;
        int effort = this.effort;
        int size = sockets.length;
        switch (size) {
            case 1: {
                pooledRSocket = sockets[0];
                break;
            }
            case 2: {
                PooledRSocket rsc1 = sockets[0];
                PooledRSocket rsc2 = sockets[1];
                double w1 = WeightedLoadbalanceStrategy.algorithmicWeight(rsc1);
                double w2 = WeightedLoadbalanceStrategy.algorithmicWeight(rsc2);
                if (w1 < w2) {
                    pooledRSocket = rsc2;
                    break;
                }
                pooledRSocket = rsc1;
                break;
            }
            default: {
                double w2;
                double w1;
                PooledRSocket rsc1 = null;
                PooledRSocket rsc2 = null;
                for (int i = 0; i < effort; ++i) {
                    int i1 = ThreadLocalRandom.current().nextInt(size);
                    int i2 = ThreadLocalRandom.current().nextInt(size - 1);
                    if (i2 >= i1) {
                        ++i2;
                    }
                    rsc1 = sockets[i1];
                    rsc2 = sockets[i2];
                    if (rsc1.availability() > 0.0 && rsc2.availability() > 0.0) break;
                }
                pooledRSocket = (w1 = WeightedLoadbalanceStrategy.algorithmicWeight(rsc1)) < (w2 = WeightedLoadbalanceStrategy.algorithmicWeight(rsc2)) ? rsc2 : rsc1;
            }
        }
        return pooledRSocket;
    }

    private static double algorithmicWeight(@Nullable PooledRSocket pooledRSocket) {
        if (pooledRSocket == null || pooledRSocket.isDisposed() || pooledRSocket.availability() == 0.0) {
            return 0.0;
        }
        Stats stats = pooledRSocket.stats();
        int pending = stats.pending();
        double latency = stats.predictedLatency();
        double low = stats.lowerQuantileLatency();
        double high = Math.max(stats.higherQuantileLatency(), low * 1.001);
        double bandWidth = Math.max(high - low, 1.0);
        if (latency < low) {
            latency /= WeightedLoadbalanceStrategy.calculateFactor(low, latency, bandWidth);
        } else if (latency > high) {
            latency *= WeightedLoadbalanceStrategy.calculateFactor(latency, high, bandWidth);
        }
        return pooledRSocket.availability() * 1.0 / (1.0 + latency * (double)(pending + 1));
    }

    private static double calculateFactor(double u, double l, double bandWidth) {
        double alpha = (u - l) / bandWidth;
        return Math.pow(1.0 + alpha, 4.0);
    }
}

