/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.loadbalance;

import io.netty.util.ReferenceCountUtil;
import io.rsocket.Payload;
import io.rsocket.frame.FrameType;
import io.rsocket.loadbalance.ResolvingOperator;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.BiConsumer;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Scannable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

abstract class MonoDeferredResolution<RESULT, R>
extends Mono<RESULT>
implements CoreSubscriber<RESULT>,
Subscription,
Scannable,
BiConsumer<R, Throwable> {
    final ResolvingOperator<R> parent;
    final Payload payload;
    final FrameType requestType;
    volatile long requested;
    static final AtomicLongFieldUpdater<MonoDeferredResolution> REQUESTED = AtomicLongFieldUpdater.newUpdater(MonoDeferredResolution.class, "requested");
    static final long STATE_UNSUBSCRIBED = -1L;
    static final long STATE_SUBSCRIBER_SET = 0L;
    static final long STATE_SUBSCRIBED = -2L;
    static final long STATE_TERMINATED = Long.MIN_VALUE;
    Subscription s;
    CoreSubscriber<? super RESULT> actual;
    boolean done;

    MonoDeferredResolution(ResolvingOperator<R> parent, Payload payload, FrameType requestType) {
        this.parent = parent;
        this.payload = payload;
        this.requestType = requestType;
        REQUESTED.lazySet(this, -1L);
    }

    public void subscribe(CoreSubscriber<? super RESULT> actual) {
        if (this.requested == -1L && REQUESTED.compareAndSet(this, -1L, 0L)) {
            actual.onSubscribe((Subscription)this);
            if (this.requested == Long.MIN_VALUE) {
                return;
            }
            this.actual = actual;
            this.parent.observe(this);
        } else {
            Operators.error(actual, (Throwable)new IllegalStateException("Only a single Subscriber allowed"));
        }
    }

    public final Context currentContext() {
        return this.actual.currentContext();
    }

    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        long state = this.requested;
        if (key == Scannable.Attr.PARENT) {
            return this.s;
        }
        if (key == Scannable.Attr.ACTUAL) {
            return this.parent;
        }
        if (key == Scannable.Attr.TERMINATED) {
            return this.done;
        }
        if (key == Scannable.Attr.CANCELLED) {
            return state == Long.MIN_VALUE;
        }
        return null;
    }

    public final void onSubscribe(Subscription s) {
        long r;
        long state = this.requested;
        Subscription a = this.s;
        if (state == Long.MIN_VALUE) {
            s.cancel();
            return;
        }
        if (a != null) {
            s.cancel();
            return;
        }
        long accumulated = 0L;
        do {
            if ((r = this.requested) == Long.MIN_VALUE || r == -2L) {
                s.cancel();
                return;
            }
            this.s = s;
            long toRequest = r - accumulated;
            if (toRequest > 0L) {
                s.request(toRequest);
            }
            accumulated = r;
        } while (!REQUESTED.compareAndSet(this, r, -2L));
    }

    public final void onNext(RESULT payload) {
        this.actual.onNext(payload);
    }

    public void onError(Throwable t) {
        if (this.done) {
            Operators.onErrorDropped((Throwable)t, (Context)this.actual.currentContext());
            return;
        }
        this.done = true;
        this.actual.onError(t);
    }

    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.actual.onComplete();
    }

    public final void request(long n) {
        if (Operators.validate((long)n)) {
            long r = this.requested;
            if (r > -2L) {
                do {
                    if (r == Long.MAX_VALUE) {
                        return;
                    }
                    long u = Operators.addCap((long)r, (long)n);
                    if (!REQUESTED.compareAndSet(this, r, u)) continue;
                    return;
                } while ((r = this.requested) >= 0L);
            }
            if (r == Long.MIN_VALUE) {
                return;
            }
            this.s.request(n);
        }
    }

    public void cancel() {
        long state = REQUESTED.getAndSet(this, Long.MIN_VALUE);
        if (state == Long.MIN_VALUE) {
            return;
        }
        if (state == -2L) {
            this.s.cancel();
        } else {
            this.parent.remove(this);
            ReferenceCountUtil.safeRelease((Object)this.payload);
        }
    }

    boolean isTerminated() {
        return this.requested == Long.MIN_VALUE;
    }
}

