/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.internal;

import io.netty.util.ReferenceCounted;
import io.rsocket.internal.jctools.queues.MpscUnboundedArrayQueue;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.FluxProcessor;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;
import reactor.util.concurrent.Queues;
import reactor.util.context.Context;

public final class UnboundedProcessor<T>
extends FluxProcessor<T, T>
implements Fuseable.QueueSubscription<T>,
Fuseable {
    final Queue<T> queue = new MpscUnboundedArrayQueue<T>(Queues.SMALL_BUFFER_SIZE);
    final Queue<T> priorityQueue = new MpscUnboundedArrayQueue<T>(Queues.SMALL_BUFFER_SIZE);
    volatile boolean done;
    Throwable error;
    boolean hasDownstream;
    volatile CoreSubscriber<? super T> actual;
    volatile boolean cancelled;
    volatile int once;
    static final AtomicIntegerFieldUpdater<UnboundedProcessor> ONCE = AtomicIntegerFieldUpdater.newUpdater(UnboundedProcessor.class, "once");
    volatile int wip;
    static final AtomicIntegerFieldUpdater<UnboundedProcessor> WIP = AtomicIntegerFieldUpdater.newUpdater(UnboundedProcessor.class, "wip");
    volatile int discardGuard;
    static final AtomicIntegerFieldUpdater<UnboundedProcessor> DISCARD_GUARD = AtomicIntegerFieldUpdater.newUpdater(UnboundedProcessor.class, "discardGuard");
    volatile long requested;
    static final AtomicLongFieldUpdater<UnboundedProcessor> REQUESTED = AtomicLongFieldUpdater.newUpdater(UnboundedProcessor.class, "requested");
    boolean outputFused;

    public int getBufferSize() {
        return Integer.MAX_VALUE;
    }

    public Object scanUnsafe(Scannable.Attr key) {
        if (Scannable.Attr.BUFFERED == key) {
            return this.queue.size();
        }
        if (Scannable.Attr.PREFETCH == key) {
            return Integer.MAX_VALUE;
        }
        return super.scanUnsafe(key);
    }

    void drainRegular(Subscriber<? super T> a) {
        int missed = 1;
        Queue<T> q = this.queue;
        Queue<T> pq = this.priorityQueue;
        do {
            long e;
            long r = this.requested;
            for (e = 0L; r != e; ++e) {
                boolean empty;
                T t;
                boolean d = this.done;
                if (!pq.isEmpty()) {
                    t = pq.poll();
                    empty = false;
                } else {
                    t = q.poll();
                    boolean bl = empty = t == null;
                }
                if (this.checkTerminated(d, empty, a)) {
                    return;
                }
                if (empty) break;
                a.onNext(t);
            }
            if (r == e && this.checkTerminated(this.done, q.isEmpty() && pq.isEmpty(), a)) {
                return;
            }
            if (e == 0L || r == Long.MAX_VALUE) continue;
            REQUESTED.addAndGet(this, -e);
        } while ((missed = WIP.addAndGet(this, -missed)) != 0);
    }

    void drainFused(Subscriber<? super T> a) {
        int missed = 1;
        do {
            if (this.cancelled) {
                this.clear();
                this.hasDownstream = false;
                return;
            }
            boolean d = this.done;
            a.onNext(null);
            if (!d) continue;
            this.hasDownstream = false;
            Throwable ex = this.error;
            if (ex != null) {
                a.onError(ex);
            } else {
                a.onComplete();
            }
            return;
        } while ((missed = WIP.addAndGet(this, -missed)) != 0);
    }

    public void drain() {
        if (WIP.getAndIncrement(this) != 0) {
            if (this.cancelled) {
                this.clear();
            }
            return;
        }
        int missed = 1;
        do {
            CoreSubscriber<? super T> a;
            if ((a = this.actual) == null) continue;
            if (this.outputFused) {
                this.drainFused((Subscriber<? super T>)a);
            } else {
                this.drainRegular((Subscriber<? super T>)a);
            }
            return;
        } while ((missed = WIP.addAndGet(this, -missed)) != 0);
    }

    boolean checkTerminated(boolean d, boolean empty, Subscriber<? super T> a) {
        if (this.cancelled) {
            this.clear();
            this.hasDownstream = false;
            return true;
        }
        if (d && empty) {
            Throwable e = this.error;
            this.hasDownstream = false;
            if (e != null) {
                a.onError(e);
            } else {
                a.onComplete();
            }
            return true;
        }
        return false;
    }

    public void onSubscribe(Subscription s) {
        if (this.done || this.cancelled) {
            s.cancel();
        } else {
            s.request(Long.MAX_VALUE);
        }
    }

    public int getPrefetch() {
        return Integer.MAX_VALUE;
    }

    public Context currentContext() {
        CoreSubscriber<? super T> actual = this.actual;
        return actual != null ? actual.currentContext() : Context.empty();
    }

    public void onNextPrioritized(T t) {
        if (this.done || this.cancelled) {
            Operators.onNextDropped(t, (Context)this.currentContext());
            this.release(t);
            return;
        }
        if (!this.priorityQueue.offer(t)) {
            Throwable ex = Operators.onOperatorError(null, (Throwable)Exceptions.failWithOverflow(), t, (Context)this.currentContext());
            this.onError(Operators.onOperatorError(null, (Throwable)ex, t, (Context)this.currentContext()));
            this.release(t);
            return;
        }
        this.drain();
    }

    public void onNext(T t) {
        if (this.done || this.cancelled) {
            Operators.onNextDropped(t, (Context)this.currentContext());
            this.release(t);
            return;
        }
        if (!this.queue.offer(t)) {
            Throwable ex = Operators.onOperatorError(null, (Throwable)Exceptions.failWithOverflow(), t, (Context)this.currentContext());
            this.onError(Operators.onOperatorError(null, (Throwable)ex, t, (Context)this.currentContext()));
            this.release(t);
            return;
        }
        this.drain();
    }

    public void onError(Throwable t) {
        if (this.done || this.cancelled) {
            Operators.onErrorDropped((Throwable)t, (Context)this.currentContext());
            return;
        }
        this.error = t;
        this.done = true;
        this.drain();
    }

    public void onComplete() {
        if (this.done || this.cancelled) {
            return;
        }
        this.done = true;
        this.drain();
    }

    public void subscribe(CoreSubscriber<? super T> actual) {
        Objects.requireNonNull(actual, "subscribe");
        if (this.once == 0 && ONCE.compareAndSet(this, 0, 1)) {
            actual.onSubscribe((Subscription)this);
            this.actual = actual;
            if (this.cancelled) {
                this.hasDownstream = false;
            } else {
                this.drain();
            }
        } else {
            Operators.error(actual, (Throwable)new IllegalStateException("UnboundedProcessor allows only a single Subscriber"));
        }
    }

    public void request(long n) {
        if (Operators.validate((long)n)) {
            Operators.addCap(REQUESTED, (Object)((Object)this), (long)n);
            this.drain();
        }
    }

    public void cancel() {
        if (this.cancelled) {
            return;
        }
        this.cancelled = true;
        if (WIP.getAndIncrement(this) == 0) {
            this.clear();
            this.hasDownstream = false;
        }
    }

    @Nullable
    public T poll() {
        Queue<T> pq = this.priorityQueue;
        if (!pq.isEmpty()) {
            return pq.poll();
        }
        return this.queue.poll();
    }

    public int size() {
        return this.priorityQueue.size() + this.queue.size();
    }

    public boolean isEmpty() {
        return this.priorityQueue.isEmpty() && this.queue.isEmpty();
    }

    public void clear() {
        if (DISCARD_GUARD.getAndIncrement(this) != 0) {
            return;
        }
        int missed = 1;
        while (true) {
            T t;
            if (!this.queue.isEmpty()) {
                t = this.queue.poll();
                if (t == null) continue;
                this.release(t);
                continue;
            }
            while (!this.priorityQueue.isEmpty()) {
                t = this.priorityQueue.poll();
                if (t == null) continue;
                this.release(t);
            }
            if ((missed = DISCARD_GUARD.addAndGet(this, -missed)) == 0) break;
        }
    }

    public int requestFusion(int requestedMode) {
        if ((requestedMode & 2) != 0) {
            this.outputFused = true;
            return 2;
        }
        return 0;
    }

    public void dispose() {
        this.cancel();
    }

    public boolean isDisposed() {
        return this.cancelled || this.done;
    }

    public boolean isTerminated() {
        return this.done;
    }

    @Nullable
    public Throwable getError() {
        return this.error;
    }

    public long downstreamCount() {
        return this.hasDownstreams() ? 1L : 0L;
    }

    public boolean hasDownstreams() {
        return this.hasDownstream;
    }

    void release(T t) {
        ReferenceCounted refCounted;
        if (t instanceof ReferenceCounted && (refCounted = (ReferenceCounted)t).refCnt() > 0) {
            try {
                refCounted.release();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

