/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.core;

import io.rsocket.Payload;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.Operators;
import reactor.core.publisher.SignalType;
import reactor.util.context.Context;

abstract class RequestOperator
implements CoreSubscriber<Payload>,
Fuseable.QueueSubscription<Payload> {
    final CoreSubscriber<? super Payload> actual;
    Subscription s;
    Fuseable.QueueSubscription<Payload> qs;
    int streamId;
    boolean firstRequest = true;
    volatile int wip;
    static final AtomicIntegerFieldUpdater<RequestOperator> WIP = AtomicIntegerFieldUpdater.newUpdater(RequestOperator.class, "wip");

    RequestOperator(CoreSubscriber<? super Payload> actual) {
        this.actual = actual;
    }

    void hookOnFirstRequest(long n) {
    }

    void hookOnRemainingRequests(long n) {
    }

    void hookOnCancel() {
    }

    void hookOnTerminal(SignalType signalType) {
    }

    public Context currentContext() {
        return this.actual.currentContext();
    }

    public void request(long n) {
        this.s.request(n);
        if (!this.firstRequest) {
            try {
                this.hookOnRemainingRequests(n);
            }
            catch (Throwable throwable) {
                this.onError(throwable);
            }
            return;
        }
        if (WIP.getAndIncrement(this) != 0) {
            return;
        }
        this.firstRequest = false;
        int missed = 1;
        boolean firstLoop = true;
        do {
            if (firstLoop) {
                firstLoop = false;
                try {
                    this.hookOnFirstRequest(n);
                }
                catch (Throwable throwable) {
                    this.onError(throwable);
                    return;
                }
            }
            try {
                this.hookOnCancel();
            }
            catch (Throwable throwable) {
                this.onError(throwable);
            }
            return;
        } while ((missed = WIP.addAndGet(this, -missed)) != 0);
    }

    public void cancel() {
        this.s.cancel();
        if (WIP.getAndIncrement(this) != 0) {
            return;
        }
        this.hookOnCancel();
    }

    public void onSubscribe(Subscription s) {
        if (Operators.validate((Subscription)this.s, (Subscription)s)) {
            this.s = s;
            if (s instanceof Fuseable.QueueSubscription) {
                this.qs = (Fuseable.QueueSubscription)s;
            }
            this.actual.onSubscribe((Subscription)this);
        }
    }

    public void onNext(Payload t) {
        this.actual.onNext((Object)t);
    }

    public void onError(Throwable t) {
        this.actual.onError(t);
        try {
            this.hookOnTerminal(SignalType.ON_ERROR);
        }
        catch (Throwable throwable) {
            Operators.onErrorDropped((Throwable)throwable, (Context)this.currentContext());
        }
    }

    public void onComplete() {
        this.actual.onComplete();
        try {
            this.hookOnTerminal(SignalType.ON_COMPLETE);
        }
        catch (Throwable throwable) {
            Operators.onErrorDropped((Throwable)throwable, (Context)this.currentContext());
        }
    }

    public int requestFusion(int requestedMode) {
        if (this.qs != null) {
            return this.qs.requestFusion(requestedMode);
        }
        return 0;
    }

    public Payload poll() {
        return (Payload)this.qs.poll();
    }

    public int size() {
        return this.qs.size();
    }

    public boolean isEmpty() {
        return this.qs.isEmpty();
    }

    public void clear() {
        this.qs.clear();
    }
}

