/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.plugins;

import io.rsocket.plugins.DuplexConnectionInterceptor;
import io.rsocket.plugins.RSocketInterceptor;
import io.rsocket.plugins.SocketAcceptorInterceptor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class InterceptorRegistry {
    private List<DuplexConnectionInterceptor> connectionInterceptors = new ArrayList<DuplexConnectionInterceptor>();
    private List<RSocketInterceptor> requesterInteceptors = new ArrayList<RSocketInterceptor>();
    private List<RSocketInterceptor> responderInterceptors = new ArrayList<RSocketInterceptor>();
    private List<SocketAcceptorInterceptor> socketAcceptorInterceptors = new ArrayList<SocketAcceptorInterceptor>();

    public InterceptorRegistry forConnection(DuplexConnectionInterceptor interceptor) {
        this.connectionInterceptors.add(interceptor);
        return this;
    }

    public InterceptorRegistry forConnection(Consumer<List<DuplexConnectionInterceptor>> consumer) {
        consumer.accept(this.connectionInterceptors);
        return this;
    }

    public InterceptorRegistry forRequester(RSocketInterceptor interceptor) {
        this.requesterInteceptors.add(interceptor);
        return this;
    }

    public InterceptorRegistry forRequester(Consumer<List<RSocketInterceptor>> consumer) {
        consumer.accept(this.requesterInteceptors);
        return this;
    }

    public InterceptorRegistry forResponder(RSocketInterceptor interceptor) {
        this.responderInterceptors.add(interceptor);
        return this;
    }

    public InterceptorRegistry forResponder(Consumer<List<RSocketInterceptor>> consumer) {
        consumer.accept(this.responderInterceptors);
        return this;
    }

    public InterceptorRegistry forSocketAcceptor(SocketAcceptorInterceptor interceptor) {
        this.socketAcceptorInterceptors.add(interceptor);
        return this;
    }

    public InterceptorRegistry forSocketAcceptor(Consumer<List<SocketAcceptorInterceptor>> consumer) {
        consumer.accept(this.socketAcceptorInterceptors);
        return this;
    }

    List<DuplexConnectionInterceptor> getConnectionInterceptors() {
        return this.connectionInterceptors;
    }

    List<RSocketInterceptor> getRequesterInteceptors() {
        return this.requesterInteceptors;
    }

    List<RSocketInterceptor> getResponderInterceptors() {
        return this.responderInterceptors;
    }

    List<SocketAcceptorInterceptor> getSocketAcceptorInterceptors() {
        return this.socketAcceptorInterceptors;
    }
}

